/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

import java.io.File;
import net.sf.samtools.BAMFileWriter;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;

public class BAMFixConsecutiveDuplicates {
    public static int fix_consecutive_duplicates(File src_file, File out_file) {
        SAMFileReader sfr_src = new SAMFileReader(src_file);
        BAMFileWriter bfw = new BAMFileWriter(out_file);
        SAMFileHeader header_in = sfr_src.getFileHeader();
        bfw.setSortOrder(header_in.getSortOrder(), true);
        bfw.setHeader(header_in);
        SAMRecord sr_last = null;
        int removed = 0;
        for (SAMRecord sr : sfr_src) {
            if (sr_last != null && sr.getReadName().equals(sr_last.getReadName()) && sr.getReferenceIndex().equals(sr_last.getReferenceIndex()) && sr.getAlignmentStart() == sr_last.getAlignmentStart() && sr.getReadNegativeStrandFlag() == sr_last.getReadNegativeStrandFlag()) {
                ++removed;
                continue;
            }
            bfw.addAlignment(sr);
            sr_last = sr;
        }
        bfw.close();
        return removed;
    }

    public static void main(String[] argv) {
        File bam_in = null;
        File bam_out = null;
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-in")) {
                bam_in = new File(argv[++i]);
                continue;
            }
            if (!argv[i].equals("-out")) continue;
            bam_out = new File(argv[++i]);
        }
        if (bam_in != null && bam_out != null) {
            BAMFixConsecutiveDuplicates.fix_consecutive_duplicates(bam_in, bam_out);
        } else {
            System.err.println("ERROR: specify -in and -out");
        }
    }
}

