/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

import IsoView.Transcript;
import IsoView.TranscriptExon;
import IsoView.TranscriptFeature;
import IsoView.TranscriptIntron;
import java.util.HashSet;

public class DuplicateFeatureFilter {
    String last_sample;
    HashSet<String> tracker;

    public DuplicateFeatureFilter() {
        this.reset(null);
    }

    private void reset(String sample) {
        this.tracker = new HashSet();
        this.last_sample = sample;
    }

    public boolean are_any_usable(Transcript t) {
        boolean usable = false;
        if (!t.sample_name.equals(this.last_sample)) {
            this.reset(t.sample_name);
            usable = true;
        } else {
            usable = false;
            for (TranscriptExon te : t.exons) {
                if (!this.is_usable(te)) continue;
                usable = true;
            }
            for (TranscriptIntron ti : t.introns) {
                if (!this.is_usable(ti)) continue;
                usable = true;
            }
        }
        return usable;
    }

    public boolean is_usable(TranscriptFeature tf) {
        String key;
        boolean usable = false;
        if (!tf.transcript.sample_name.equals(this.last_sample)) {
            this.reset(tf.transcript.sample_name);
        }
        usable = !this.tracker.contains(key = tf.get_basic_hash_string());
        this.tracker.add(key);
        return usable;
    }
}

