/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

import IsoView.MD5Util;
import IsoView.Transcript;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicateTranscriptIdentifier
implements Runnable {
    public ArrayList<Transcript> all_transcripts;

    public DuplicateTranscriptIdentifier(ArrayList<Transcript> all_transcripts, boolean async) {
        this.all_transcripts = all_transcripts;
        if (async) {
            new Thread(this).start();
        } else {
            this.run();
        }
    }

    @Override
    public void run() {
        try {
            HashMap<String, MD5Util> bucket = new HashMap<String, MD5Util>();
            for (Transcript t : this.all_transcripts) {
                MD5Util md5 = (MD5Util)bucket.get(t.transcript_id);
                if (md5 == null) {
                    md5 = new MD5Util();
                    bucket.put(t.transcript_id, md5);
                }
                md5.update(t.get_md5());
            }
            HashMap<String, Transcript> saw = new HashMap<String, Transcript>();
            for (Transcript t : this.all_transcripts) {
                MD5Util md5 = (MD5Util)bucket.get(t.transcript_id);
                String hex = md5.get_hex_digest();
                if (saw.containsKey(hex)) {
                    Transcript t_prev = (Transcript)saw.get(hex);
                    if (t.transcript_id.equals(t_prev.transcript_id)) continue;
                    System.err.println("duplicate!! " + t.transcript_id + " " + t_prev.transcript_id);
                    t.duplicate = t_prev;
                    continue;
                }
                saw.put(hex, t);
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
        }
    }
}

