/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

import Funk.Str;
import java.util.HashMap;

public class GTFFeature {
    public String seqname;
    public String source;
    public String feature;
    public int start;
    public int end;
    public double score;
    public String strand;
    public int frame;
    public String group;
    public HashMap<String, String> attributes = new HashMap();
    public static final int GTF_FIELD_COUNT = 9;
    public static final String GTF_UNDEF = ".";
    public static final int GTF_NULL = -1;

    public GTFFeature(String[] data) {
        if (data.length == 9) {
            this.seqname = new String(data[0]);
            this.source = new String(data[1]);
            this.feature = new String(data[2]);
            this.start = Integer.parseInt(data[3]);
            this.end = Integer.parseInt(data[4]);
            this.score = this.parse_double(data[5]);
            this.strand = new String(data[6]);
            this.frame = this.parse_int(data[7]);
            this.group = new String(data[8]);
            String[] attrs = this.group.split("; ");
            for (int i = 0; i < attrs.length; ++i) {
                String[] kv = Str.trim_whitespace(attrs[i]).split(" ");
                if (kv.length == 2) {
                    String key = kv[0];
                    String value = Str.unquote(kv[1]);
                    this.attributes.put(key, value);
                    continue;
                }
                System.err.println("ERROR parsing attr: " + attrs[i] + " fields=" + kv.length);
            }
        } else {
            System.err.println("ERROR: incorrect field count");
        }
    }

    private int parse_int(String s) {
        int result = s.equals(GTF_UNDEF) ? -1 : Integer.parseInt(s);
        return result;
    }

    private double parse_double(String s) {
        double result = s.equals(GTF_UNDEF) ? -1.0 : Double.parseDouble(s);
        return result;
    }

    public String get_attribute(String key) {
        return this.attributes.get(key);
    }
}

