/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

import Ace2.Counter;
import IsoView.GTFFeature;
import IsoView.GTFReader;
import IsoView.Transcript;
import IsoView.TranscriptExon;
import IsoView.TranscriptLoader;

public class GTFTranscriptLoader
extends TranscriptLoader {
    public GTFTranscriptLoader(GTFReader gtf) {
        this.load_from_gtf(gtf);
    }

    private void load_from_gtf(GTFReader gtf) {
        Counter counter = new Counter();
        for (GTFFeature f : gtf.get_features()) {
            String njc;
            String tid = f.get_attribute("transcript_id");
            Transcript t = (Transcript)this.id2transcript.get(tid);
            if (t == null) {
                t = new Transcript();
                t.sample_name = new String(gtf.get_filename());
                t.transcript_id = new String(tid);
                t.strand = new String(f.strand);
                this.id2transcript.put(tid, t);
                this.all_transcripts.add(t);
            }
            TranscriptExon te = new TranscriptExon();
            te.transcript = t;
            te.reference = new String(f.seqname);
            te.gene_name = new String(f.get_attribute("gene_id"));
            String exno = f.get_attribute("exon_number");
            if (exno == null) {
                te.feature_number = (int)counter.increment(tid);
                if (t.exons.size() > 0) {
                    TranscriptExon te_last = t.exons.get(t.exons.size() - 1);
                    if (te_last.start > f.start) {
                        System.err.println("FATAL: exons out of order: last start=" + te_last.start + " " + " this start= " + f.start);
                        System.exit(1);
                    }
                }
            } else {
                te.feature_number = Integer.parseInt(exno);
            }
            if ((njc = f.get_attribute("next_junction_coverage")) != null) {
                te.next_junction_coverage = Integer.parseInt(njc);
            }
            te.start = f.start;
            te.end = f.end;
            t.exons.add(te);
        }
        this.transcript_setup();
        for (Transcript t : this.all_transcripts) {
            int end = t.exons.size() - 1;
            for (int i = 0; i < end; ++i) {
                int jc = t.exons.get((int)i).next_junction_coverage;
                if (jc == -1) continue;
                t.introns.get((int)i).junction_coverage = jc;
            }
        }
    }

    public static void main(String[] argv) {
        try {
            String gtf_file = null;
            for (int i = 0; i < argv.length; ++i) {
                if (!argv[i].equals("-gtf")) continue;
                gtf_file = argv[++i];
            }
            if (gtf_file == null) {
                System.err.println("ERROR: specify -gtf");
            } else {
                GTFReader gtf = new GTFReader(gtf_file);
                GTFTranscriptLoader gTFTranscriptLoader = new GTFTranscriptLoader(gtf);
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
        }
    }
}

