/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphicsTracker {
    private Graphics2D g;
    private HashMap<Rectangle, Object> rectangles = new HashMap();
    private int buffer = 0;
    private int buffer_double = 0;

    public GraphicsTracker(Graphics2D g) {
        this.g = g;
    }

    public void set_buffer_pixels(int px) {
        this.buffer = px;
        this.buffer_double = px * 2;
    }

    public void fillRect(Object o, int x, int y, int width, int height) {
        this.g.fillRect(x, y, width, height);
        this.rectangles.put(new Rectangle(x - this.buffer, y - this.buffer, width + this.buffer_double, height + this.buffer_double), o);
    }

    public void drawLine(Object o, int x1, int y1, int x2, int y2) {
        this.g.drawLine(x1, y1, x2, y2);
        this.rectangles.put(new Rectangle(x1 - this.buffer, y1 - this.buffer, x2 - x1 + 1 + this.buffer_double, y2 - y1 + 1 + this.buffer_double), o);
    }

    public ArrayList<Object> find_intersecting_list(MouseEvent me) {
        return this.find_intersecting_list(me.getX(), me.getY());
    }

    public ArrayList<Object> find_intersecting_list(int x, int y) {
        ArrayList<Object> results = new ArrayList<Object>();
        for (Rectangle r : this.rectangles.keySet()) {
            if (!r.contains(x, y)) continue;
            results.add(this.rectangles.get(r));
        }
        return results;
    }

    public Object find_intersecting(MouseEvent me) {
        return this.find_intersecting(me.getX(), me.getY());
    }

    public Object find_intersecting(int x, int y) {
        Object result = null;
        for (Rectangle r : this.rectangles.keySet()) {
            if (!r.contains(x, y)) continue;
            result = this.rectangles.get(r);
            break;
        }
        return result;
    }
}

