/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

import IsoView.RangeDigest;
import IsoView.RangeDigestSet;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMRecord;

public class InternalSpliceFilter {
    private RangeDigestSet rds;
    private static final String CIGAR_SKIP = CigarOperator.SKIPPED_REGION.toString();

    public InternalSpliceFilter(RangeDigestSet rds) {
        this.rds = rds;
    }

    public boolean has_internal_splice(SAMRecord sr) {
        boolean result = false;
        Cigar cigar = sr.getCigar();
        if (cigar.toString().indexOf(CIGAR_SKIP) > -1) {
            int pos = sr.getUnclippedStart();
            for (CigarElement ce : cigar.getCigarElements()) {
                CigarOperator co = ce.getOperator();
                int len = ce.getLength();
                if (co.equals((Object)CigarOperator.MATCH_OR_MISMATCH) || co.equals((Object)CigarOperator.DELETION) || co.equals((Object)CigarOperator.SOFT_CLIP) || co.equals((Object)CigarOperator.HARD_CLIP)) {
                    pos += len;
                    continue;
                }
                if (co.equals((Object)CigarOperator.PADDING) || co.equals((Object)CigarOperator.INSERTION)) continue;
                if (co.equals((Object)CigarOperator.SKIPPED_REGION)) {
                    int start = pos;
                    int end = start + len - 1;
                    System.err.println("skip " + sr.getReadName() + " from " + start + "-" + end);
                    for (RangeDigest rd : this.rds.get_ranges()) {
                        RangeDigest hit_end;
                        RangeDigest hit_start = rd.intersects(start) ? rd : null;
                        RangeDigest rangeDigest = hit_end = rd.intersects(end) ? rd : null;
                        if (hit_start == null || hit_end == null || !hit_start.equals(hit_end)) continue;
                        result = true;
                    }
                    continue;
                }
                System.err.println("ERROR: unhandled CIGAR operator in internal splice filter");
            }
        }
        return result;
    }
}

