/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

import Ace2.TwoBitFile;
import IsoView.Transcript;
import IsoView.TranscriptCoordinateDigest;
import TCGA.BooleanOption;
import TCGA.BooleanOptionGroup;
import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class IsoViewConfig {
    ArrayList<String> track_files = new ArrayList();
    ArrayList<String> junction_count_files = new ArrayList();
    HashMap<String, String> sample2bam = new HashMap();
    ArrayList<Transcript> reference_transcripts = null;
    boolean SAMPLE_SEPARATOR_DASHED = false;
    boolean MANUAL_JUNCTION_MODE = false;
    String MANUAL_JUNCTION_GENE = null;
    boolean FLATFILE_JUNCTION_MODE = false;
    boolean SHOW_JUNCTION_COUNTS = false;
    boolean LOAD_NOVEL_JUNCTIONS_ONLY = false;
    boolean LOAD_KNOWN_REFGENE_ONLY = false;
    Color JUNCTION_COUNT_COLOR = Color.white;
    Color JUNCTION_COUNT_COLOR_KNOWN = null;
    Color JUNCTION_COUNT_COLOR_NOVEL = null;
    String JUNCTION_COUNT_FONT_NAME = "SanSerif";
    int JUNCTION_COUNT_FONT_SIZE = 11;
    String NULL_GENE_SYMBOL_OVERRIDE = null;
    boolean PRUNE_NULL_COUNT_JUNCTIONS = true;
    String F_JUNCTION = "junction";
    String F_GENE = "gene";
    String F_COUNT = null;
    String F_TYPE = null;
    String F_TRANSCRIPT = null;
    String two_bit_file = "c:/generatable/ucsc/hg19.2bit";
    TwoBitFile two_bit;
    HashSet<String> genes_to_view = new HashSet();
    String sample_to_view = null;
    String transcript_to_view = null;
    String reference_transcript_to_view = null;
    String refgene_flatfile = null;
    String refgene_gtf = null;
    boolean STANDARDIZE_GENE_SYMBOLS = false;
    String standardize_flatfile = null;
    boolean USE_TRANSCRIPT2GENE = false;
    String transcript2gene_file = null;
    ArrayList<String> all_genes;
    ArrayList<String> all_transcript_ids;
    ArrayList<Transcript> all_transcripts;
    ArrayList<Transcript> working_transcripts;
    TranscriptCoordinateDigest scale_digest;
    boolean FADE_INTRON_COLOR_AT_HIGH_ZOOM_OUT = true;
    boolean ENABLE_VERTICAL_ZOOM = true;
    BooleanOption REQUIRE_MATE_ALIGN = new BooleanOption(false);
    BooleanOption EXTRACT_EXCERPT_BAM_MODE = new BooleanOption(false);
    BooleanOption BAMVIEW_COMPRESS_INTRONS = new BooleanOption(true);
    BooleanOption TOOLTIP_GROUP_REFSEQ_EVENTS_BY_EVENT = new BooleanOption(false, "Group reference match types in tooltips");
    BooleanOption SORT_UNSORTED = new BooleanOption(true, "unsorted");
    BooleanOption SORT_SAMPLE = new BooleanOption(false, "by sample");
    BooleanOption SORT_SPAN_SIZE = new BooleanOption(false, "by span size");
    BooleanOption SORT_PRODUCT_SIZE = new BooleanOption(false, "by product size");
    BooleanOption SORT_FIRST_EXON = new BooleanOption(false, "by first exon position");
    BooleanOption SORT_SIMILARITY = new BooleanOption(false, "by similarity (development)");
    BooleanOption SORT_INTRON_SIZES = new BooleanOption(false, "by sum of intron sizes");
    BooleanOptionGroup bog_sort;
    boolean EXPAND_EXON_UTR = true;
    int EXPAND_EXON_UTR_MINIMUM_SIZE = 125;
    Color BACKGROUND_COLOR = Color.black;
    Color COLOR_BACKGROUND_REFERENCE = new Color(60, 60, 0);
    Color COLOR_BACKGROUND_SEPARATOR = new Color(12, 12, 24);
    Color EXON_COLOR_REFERENCE;
    Color EXON_COLOR_REFERENCE_PERFECT_MATCH = this.EXON_COLOR_REFERENCE = Color.yellow;
    Color EXON_COLOR_REFERENCE_SAME_START_OR_END = Color.green;
    Color EXON_COLOR_REFERENCE_PARTIAL_MATCH = Color.blue;
    Color EXON_COLOR_REFERENCE_NO_MATCH = Color.red;
    Color EXON_COLOR_MULTI_EXON_SPAN = new Color(0, 110, 0);
    Color EXON_COLOR = Color.white;
    Color INTRON_COLOR = Color.gray;
    int EXON_ASCENT_SIZE = 4;
    int CANVAS_TRANSCRIPT_Y_SIZE = 16;
    static boolean DEBUG_PRUNE = false;
    int ARROW_ASCENT_SIZE = this.EXON_ASCENT_SIZE - 2;
    boolean ENABLE_ANTIALIASING = true;
    BooleanOption HIDE_DUPLICATE_TRANSCRIPTS = new BooleanOption(false, "Hide putative duplicate transcripts (development)");
    BooleanOption HIDE_EXON_SPANS = new BooleanOption(true, "Hide putative false exon spans");
    BooleanOption HIDE_REFERENCE_ONLY_TRANSCRIPTS = new BooleanOption(false, "Hide transcripts perfectly matching reference introns");
    BooleanOption HIDE_REFERENCE_MATCH_FEATURES = new BooleanOption(false, "Hide features matching a reference isoform");
    BooleanOption ADJUST_TRANSCRIPT_ENDS_TO_REFERENCE = new BooleanOption(true, "Adjust transcript start/end to match reference if plausible match");
    BooleanOption DRAW_FEATURES_UNIQUELY_PER_SAMPLE = new BooleanOption(false, "Display transcript features uniquely within a sample");
    BooleanOption RENDER_TO_SCALE = new BooleanOption(false);
    BooleanOption EXON_INTRON_VIEW_REQUIRE_READ_CONTAINMENT = new BooleanOption(true, "Require reads to be fully contained within transcript");
    BooleanOption EXON_INTRON_VIEW_CONTAINMENT_EDGE_FUZZY = new BooleanOption(true, "   relax this requirement for first and last exon (overlap only)");
    BooleanOption IGNORE_READS_WITH_UNKNOWN_JUNCTIONS = new BooleanOption(true, "Hide reads containing unknown junctions");
    float ZOOM_FACTOR = 1.1f;
    int MIN_JUNCTION_COVERAGE_FOR_DISPLAY = 0;
    int MIN_NOVEL_JUNCTION_COVERAGE_FOR_DISPLAY = 0;
    int BUFFER = 10;
    int FLANKING_NT_TO_GENERATE = 100;
    HashSet<String> all_reference_introns = null;

    public IsoViewConfig() {
        this.bog_sort = new BooleanOptionGroup();
        this.bog_sort.add(this.SORT_UNSORTED);
        this.bog_sort.add(this.SORT_SAMPLE);
        this.bog_sort.add(this.SORT_PRODUCT_SIZE);
        this.bog_sort.add(this.SORT_SPAN_SIZE);
        this.bog_sort.add(this.SORT_FIRST_EXON);
        this.bog_sort.add(this.SORT_SIMILARITY);
        this.bog_sort.add(this.SORT_INTRON_SIZES);
    }

    public Dimension get_raw_canvas_size() {
        int double_buf = this.BUFFER * 2;
        int tcount = this.working_transcripts.size();
        return new Dimension(this.scale_digest.get_width() + double_buf, tcount * this.CANVAS_TRANSCRIPT_Y_SIZE + double_buf);
    }

    public void add_bam(String bam) {
        String last_track = this.track_files.get(this.track_files.size() - 1);
        this.sample2bam.put(last_track, bam);
    }

    public String get_bam_filename(String sample) {
        return this.sample2bam.get(sample);
    }
}

