/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

import TCGA.ScalePanel2;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class MouseWheelZoomHelper
implements MouseWheelListener {
    ScalePanel2 isp;
    private boolean vertical_zoom_enabled = true;
    private boolean horizontal_zoom_enabled = true;
    private float zoom_factor = 1.15f;

    public MouseWheelZoomHelper(ScalePanel2 isp) {
        this.isp = isp;
        isp.addMouseWheelListener(this);
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        if ((e.getModifiers() & 0x1FA) == 0) {
            this.isp.zoom(e.getWheelRotation() < 0 ? ScalePanel2.ZOOM_DIRECTION_IN : ScalePanel2.ZOOM_DIRECTION_OUT, this.get_zoom_type(), this.zoom_factor, e.getPoint());
        }
    }

    private int get_zoom_type() {
        if (this.vertical_zoom_enabled && this.horizontal_zoom_enabled) {
            return ScalePanel2.ZOOM_AXIS_BOTH;
        }
        if (this.vertical_zoom_enabled) {
            return ScalePanel2.ZOOM_AXIS_VERTICAL;
        }
        if (this.horizontal_zoom_enabled) {
            return ScalePanel2.ZOOM_AXIS_HORIZONTAL;
        }
        return ScalePanel2.ZOOM_AXIS_NONE;
    }

    public void set_zoom_factor(float zoom_factor) {
        this.zoom_factor = zoom_factor;
    }
}

