/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

import IsoView.TranscriptFeature;
import java.awt.Rectangle;

public class RangeDigest
implements Comparable {
    public int start;
    public int end;
    private boolean is_first_start;
    private boolean is_first_end;

    public RangeDigest() {
        this.setup();
    }

    public RangeDigest(int start, int end) {
        this.setup();
        this.add_start(start);
        this.add_end(end);
    }

    public RangeDigest(TranscriptFeature tf) {
        this.setup();
        this.add_start(tf.start);
        this.add_end(tf.end);
    }

    public int compareTo(Object o) {
        RangeDigest rd_other = (RangeDigest)o;
        int result = rd_other.start == this.start ? 0 : (this.start < rd_other.start ? -1 : 1);
        return result;
    }

    private void setup() {
        this.is_first_end = true;
        this.is_first_start = true;
    }

    public void add(Rectangle r) {
        this.add_start(r.x);
        this.add_end(r.x + (r.width - 1));
    }

    public void add(RangeDigest rd) {
        this.add_start(rd.get_minimum());
        this.add_end(rd.get_maximum());
    }

    public void add_start(int x) {
        if (this.is_first_start || x < this.start) {
            this.start = x;
            this.is_first_start = false;
        }
    }

    public void add_end(int x) {
        if (this.is_first_end || x > this.end) {
            this.end = x;
            this.is_first_end = false;
        }
    }

    public void add_start_and_length(int x, int len) {
        this.add_start(x);
        this.add_end(x + (len - 1));
    }

    public void add_start_and_end(int start, int end) {
        this.add_start(start);
        this.add_end(end);
    }

    public int get_minimum() {
        return this.start;
    }

    public int get_maximum() {
        return this.end;
    }

    public int get_size() {
        return this.end - this.start + 1;
    }

    public boolean intersects(int other_start, int other_end) {
        return other_end >= this.start && other_start <= this.end;
    }

    public boolean intersects(RangeDigest other) {
        return this.intersects(other.start, other.end);
    }

    public boolean intersects(Rectangle r) {
        return this.intersects(r.x, r.x + (r.width - 1));
    }

    public boolean intersects(int i) {
        return this.intersects(i, i);
    }

    public boolean is_adjacent(RangeDigest other) {
        return other.end == this.start - 1 || other.start == this.end + 1;
    }

    public String toString() {
        return this.start + "-" + this.end;
    }

    public boolean equals(int start, int end) {
        return this.start == start && this.end == end;
    }

    public int get_overlap(RangeDigest other) {
        int overlap = 0;
        if (this.intersects(other)) {
            Rectangle r_this = this.generate_rectangle(this);
            Rectangle r_other = this.generate_rectangle(other);
            Rectangle r_overlap = r_this.intersection(r_other);
            overlap = r_overlap.width;
        }
        return overlap;
    }

    private Rectangle generate_rectangle(RangeDigest rd) {
        return new Rectangle(rd.start, 1, rd.end - rd.start + 1, 1);
    }
}

