/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

import IsoView.RangeDigest;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeDigestSet {
    private ArrayList<RangeDigest> ranges = new ArrayList();

    public void add(RangeDigest rd_new) {
        boolean eaten = false;
        for (RangeDigest rd : this.ranges) {
            if (rd.intersects(rd_new)) {
                rd.add(rd_new);
                eaten = true;
                break;
            }
            if (!rd.is_adjacent(rd_new)) continue;
            rd.add(rd_new);
            eaten = true;
            break;
        }
        if (!eaten) {
            this.ranges.add(rd_new);
        }
    }

    public boolean is_contained(int start, int end) {
        boolean result = false;
        for (RangeDigest rd : this.ranges) {
            if (start < rd.start || end > rd.end) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean intersects(int start, int end) {
        boolean result = false;
        for (RangeDigest rd : this.ranges) {
            if (end < rd.start || start > rd.end) continue;
            result = true;
            break;
        }
        return result;
    }

    public RangeDigest get(int i) {
        return this.ranges.get(i);
    }

    public int size() {
        return this.ranges.size();
    }

    public ArrayList<RangeDigest> get_ranges() {
        return this.ranges;
    }

    public static void main(String[] argv) {
        RangeDigestSet rds = new RangeDigestSet();
        rds.add(new RangeDigest(1, 10));
        rds.add(new RangeDigest(1, 10));
        rds.add(new RangeDigest(11, 20));
        rds.add(new RangeDigest(30, 50));
        System.err.println(rds.get_ranges());
    }
}

