/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

public class RegionParser
implements Comparable {
    public String reference = null;
    public Integer start = null;
    public Integer end = null;
    boolean known = false;

    public boolean parse(String s) {
        String[] start_and_end;
        String[] pos;
        boolean result = false;
        String[] ref_and_pos = s.split(":");
        if (ref_and_pos.length == 2 && (pos = ref_and_pos[1].split("-")).length == 2) {
            this.reference = new String(ref_and_pos[0]);
            this.start = Integer.parseInt(pos[0]);
            this.end = Integer.parseInt(pos[1]);
            result = true;
        }
        if ((start_and_end = s.split(",")).length == 2) {
            String[] site1 = start_and_end[0].split(":");
            String[] site2 = start_and_end[1].split(":");
            if (site1.length == 3 && site2.length == 3) {
                if (site1[0].equals(site2[0])) {
                    this.reference = new String(site1[0]);
                    this.start = Integer.parseInt(site1[1]);
                    this.end = Integer.parseInt(site2[1]);
                    result = true;
                } else {
                    System.err.println("ERROR: range on multiple references: " + s);
                }
            }
        }
        return result;
    }

    public boolean parse_junction(String junction) {
        String[] sites = junction.split(",");
        boolean status = false;
        if (sites.length == 2) {
            String[] site1 = sites[0].split(":");
            String[] site2 = sites[1].split(":");
            if (site1.length == 3 && site2.length == 3 && site1[0].equals(site2[0])) {
                this.reference = new String(site1[0]);
                this.start = Integer.parseInt(site1[1]);
                this.end = Integer.parseInt(site2[1]);
                status = true;
            }
        }
        return status;
    }

    public int compareTo(Object other) {
        RegionParser o = (RegionParser)other;
        int diff = this.reference.compareTo(o.reference);
        if (diff == 0 && (diff = this.start.compareTo(o.start)) == 0) {
            diff = this.end.compareTo(o.end);
        }
        return diff;
    }

    public String toString() {
        return this.reference + ":" + this.start + "-" + this.end;
    }

    public boolean overlaps(RegionParser other) {
        if (other.end < this.start || other.start > this.end) {
            return false;
        }
        return other.reference.equals(this.reference);
    }
}

