/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

import IsoView.IsoViewConfig;
import IsoView.Transcript;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class SeparatorPainter {
    private IsoViewConfig config;
    private Graphics2D g;
    Stroke orig_stroke;
    int ti;
    int alternator;
    String last_sample_name = null;
    double line_height;
    private Color last_color;
    Stroke dashed = new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{2.0f, 2.0f}, 0.0f);

    public SeparatorPainter(IsoViewConfig config, Graphics2D g, double line_height) {
        this.config = config;
        this.g = g;
        this.line_height = line_height;
        this.orig_stroke = g.getStroke();
        this.ti = 0;
        this.alternator = 0;
    }

    public void next(int working_y, int exon_ascent, Dimension d) {
        Transcript t = this.config.working_transcripts.get(this.ti);
        if (!t.is_reference) {
            if (this.last_sample_name != null && !t.sample_name.equals(this.last_sample_name)) {
                int top_y = working_y - exon_ascent - 1;
                if (this.config.SAMPLE_SEPARATOR_DASHED) {
                    this.g.setStroke(this.dashed);
                    this.g.setColor(Color.white);
                    this.g.drawLine(0, top_y, d.width, top_y);
                    this.g.setStroke(this.orig_stroke);
                } else {
                    this.last_color = this.alternator++ % 2 == 0 ? this.config.COLOR_BACKGROUND_SEPARATOR : this.config.BACKGROUND_COLOR;
                    int lines_needed = 1;
                    for (int i = this.ti + 1; i < this.config.working_transcripts.size() && this.config.working_transcripts.get((int)i).sample_name.equals(t.sample_name); ++i) {
                        ++lines_needed;
                    }
                    int bottom_y = (int)((double)top_y + (double)lines_needed * this.line_height);
                    this.g.setColor(this.last_color);
                    this.g.fillRect(0, top_y, d.width, bottom_y - top_y + 1);
                }
            }
            this.last_sample_name = t.sample_name;
        }
        ++this.ti;
    }

    public Color get_last_color() {
        return this.last_color;
    }
}

