/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

import IsoView.ExonMatchType;
import IsoView.MD5Util;
import IsoView.RangeDigest;
import IsoView.TranscriptExon;
import IsoView.TranscriptFeature;
import IsoView.TranscriptIntron;
import IsoView.UCSCRefGene;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transcript {
    public String sample_name;
    public String transcript_id;
    public String strand;
    public ArrayList<TranscriptExon> exons = new ArrayList();
    public ArrayList<TranscriptIntron> introns;
    private boolean is_translocation = false;
    private HashSet<String> all_genes;
    public RangeDigest screen_position;
    public boolean is_reference = false;
    public int product_size = 0;
    public int span_size = 0;
    public int total_intron_size = 0;
    MD5Util md5 = null;
    public Transcript duplicate = null;

    public Transcript() {
    }

    public Transcript(UCSCRefGene rg, boolean fix_exon_starts) {
        this.sample_name = rg.name;
        this.transcript_id = rg.name;
        this.strand = rg.strand;
        for (int i = 0; i < rg.exonCount; ++i) {
            TranscriptExon te = new TranscriptExon();
            te.transcript = this;
            te.feature_number = i + 1;
            te.reference = rg.chrom;
            te.gene_name = rg.name2;
            te.start = rg.exonStarts[i] + (fix_exon_starts ? 1 : 0);
            te.end = rg.exonEnds[i];
            this.exons.add(te);
        }
        this.setup();
    }

    public void set_gene(String gene) {
        this.all_genes = new HashSet();
        this.all_genes.add(gene);
        for (TranscriptExon te : this.exons) {
            te.gene_name = gene;
        }
    }

    public void setup() {
        this.all_genes = new HashSet();
        for (TranscriptExon te : this.exons) {
            te.raw_start = te.start;
            te.raw_end = te.end;
            this.all_genes.add(te.gene_name);
        }
        this.is_translocation = this.all_genes.size() > 1;
        this.product_size = 0;
        for (TranscriptExon e : this.exons) {
            this.product_size += e.get_size();
        }
        this.span_size = this.exons.get((int)(this.exons.size() - 1)).end - this.exons.get((int)0).start + 1;
        this.generate_introns();
        this.total_intron_size = 0;
        for (TranscriptIntron i : this.introns) {
            this.total_intron_size += i.get_size();
        }
    }

    public boolean is_translocation() {
        return this.is_translocation;
    }

    private void generate_introns() {
        this.introns = new ArrayList();
        int size = this.exons.size();
        for (int i = 0; i < size - 1; ++i) {
            this.introns.add(new TranscriptIntron(this, this.exons.get(i), this.exons.get(i + 1)));
        }
    }

    public void reset_exon_positions() {
        for (TranscriptExon te : this.exons) {
            te.start = te.raw_start;
            te.end = te.raw_end;
        }
    }

    public boolean contains_gene(String gene) {
        return this.all_genes.contains(gene);
    }

    public boolean has_null_genes() {
        return this.all_genes.size() == 1 && this.contains_gene("unknown_or_span");
    }

    public Collection<String> get_genes() {
        return this.all_genes;
    }

    public void generate_screen_position() {
        this.screen_position = new RangeDigest();
        for (TranscriptExon te : this.exons) {
            this.screen_position.add(te.screen_position);
        }
    }

    public RangeDigest get_range_digest() {
        RangeDigest rd = new RangeDigest();
        for (TranscriptExon te : this.exons) {
            rd.add_start(te.start);
            rd.add_end(te.end);
        }
        return rd;
    }

    public boolean is_plus_strand() {
        return this.strand.equals("+");
    }

    public void remap_ends_to_reference(ArrayList<Transcript> t_others) {
        TranscriptExon e_first = this.exons.get(0);
        boolean already_perfect = false;
        block0: for (Transcript t_other : t_others) {
            for (TranscriptExon e_other : t_other.exons) {
                if (e_first.start != e_other.start || e_first.end != e_other.end) continue;
                already_perfect = true;
                continue block0;
            }
        }
        if (!already_perfect) {
            block2: for (Transcript t_other : t_others) {
                for (TranscriptExon e_other : t_other.exons) {
                    if (e_first.end != e_other.end) continue;
                    e_first.start = e_other.start;
                    continue block2;
                }
            }
        }
        TranscriptExon e_last = this.exons.get(this.exons.size() - 1);
        already_perfect = false;
        block4: for (Transcript t_other : t_others) {
            for (TranscriptExon e_other : t_other.exons) {
                if (e_last.start != e_other.start || e_last.end != e_other.end) continue;
                already_perfect = true;
                continue block4;
            }
        }
        if (!already_perfect) {
            block6: for (Transcript t_other : t_others) {
                for (TranscriptExon e_other : t_other.exons) {
                    if (e_last.start != e_other.start) continue;
                    e_last.end = e_other.end;
                    continue block6;
                }
            }
        }
    }

    public void compare_with(ArrayList<Transcript> t_others, HashSet<String> all_reference_introns) {
        if (t_others.size() == 0) {
            return;
        }
        for (TranscriptIntron ti : this.introns) {
            ti.is_perfect_reference_match = all_reference_introns.contains(ti.get_range_digest().toString());
        }
        for (TranscriptExon te : this.exons) {
            HashSet<ExonMatchType> matches = new HashSet<ExonMatchType>();
            te.is_putative_span = false;
            te.is_perfect_reference_match = false;
            for (Transcript t_other : t_others) {
                TranscriptExon hit_start = null;
                TranscriptExon hit_end = null;
                for (TranscriptExon te_other : t_other.exons) {
                    ExonMatchType match_type;
                    if (te.end < te_other.start || te.start > te_other.end) continue;
                    if (te.start == te_other.start && te.end == te_other.end) {
                        match_type = ExonMatchType.PERFECT;
                        te.is_perfect_reference_match = true;
                    } else if (te.start == te_other.start) {
                        match_type = ExonMatchType.SAME_START_OR_END;
                        hit_start = te_other;
                    } else if (te.end == te_other.end) {
                        match_type = ExonMatchType.SAME_START_OR_END;
                        hit_end = te_other;
                    } else {
                        match_type = ExonMatchType.PARTIAL;
                    }
                    matches.add(match_type);
                }
                if (hit_start == null || hit_end == null) continue;
                te.is_putative_span = true;
                te.putative_span_end = hit_end;
            }
            if (matches.size() == 0) {
                te.reference_match_type = ExonMatchType.NO_MATCH;
                continue;
            }
            if (matches.size() > 1) {
                matches.remove((Object)ExonMatchType.NO_MATCH);
            }
            if (matches.size() > 1) {
                matches.remove((Object)ExonMatchType.PARTIAL);
            }
            if (matches.size() > 1) {
                matches.remove((Object)ExonMatchType.SAME_START_OR_END);
            }
            ArrayList results = new ArrayList(matches);
            te.reference_match_type = (ExonMatchType)((Object)results.get(0));
        }
    }

    public int get_first_exon_start() {
        return this.exons.get((int)0).start;
    }

    public int get_last_exon_end() {
        return this.exons.get((int)(this.exons.size() - 1)).end;
    }

    public int get_exon_count() {
        return this.exons.size();
    }

    private void build_md5() {
        if (this.md5 == null) {
            try {
                this.md5 = new MD5Util();
                this.md5.reset();
                ArrayList<TranscriptFeature> features = new ArrayList<TranscriptFeature>();
                features.addAll(this.exons);
                features.addAll(this.introns);
                for (TranscriptFeature tf : features) {
                    this.md5.update(tf.start);
                    this.md5.update(tf.end);
                }
            }
            catch (Exception e) {
                System.err.println("ERROR: " + e);
            }
        }
    }

    public byte[] get_md5() {
        this.build_md5();
        return this.md5.get_digest();
    }

    public String get_md5_hex() {
        this.build_md5();
        return this.md5.get_hex_digest();
    }
}

