/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

import IsoView.RangeDigest;
import IsoView.Transcript;
import IsoView.TranscriptCoordinateDigest;
import IsoView.TranscriptExon;
import IsoView.TranscriptIntron;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranscriptCoordinateDigestToScale
extends TranscriptCoordinateDigest {
    public TranscriptCoordinateDigestToScale(ArrayList<Transcript> transcripts) {
        this.transcripts = transcripts;
    }

    @Override
    public void digest() {
        HashSet<String> all_refs = new HashSet<String>();
        RangeDigest rd = new RangeDigest();
        for (Transcript t : this.transcripts) {
            for (TranscriptExon te : t.exons) {
                all_refs.add(te.reference);
                rd.add_start(te.start);
                rd.add_end(te.end);
            }
        }
        if (all_refs.size() > 1) {
            System.err.println("EPIC FAIL: multiple reference sequences: " + all_refs);
            new Exception().printStackTrace();
            System.exit(1);
        }
        int min = rd.get_minimum();
        for (Transcript t : this.transcripts) {
            for (TranscriptExon te : t.exons) {
                te.screen_position = new Rectangle(te.start - min, 0, te.end - te.start + 1, 1);
            }
            for (TranscriptIntron ti : t.introns) {
                ti.screen_position = new Rectangle(ti.start - min, 0, ti.end - ti.start + 1, 1);
            }
        }
        this.generate_summary_info();
    }
}

