/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

import IsoView.JDBCQuery;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UCSCRefGene {
    int bin;
    public String name;
    public String chrom;
    public String strand;
    int txStart;
    int txEnd;
    int cdsStart;
    int cdsEnd;
    int exonCount;
    public int[] exonStarts;
    public int[] exonEnds;
    int score;
    public String name2;
    String cdsStartStat;
    String cdsEndStat;
    int[] exonFrames;

    public UCSCRefGene() {
    }

    public UCSCRefGene(HashMap<String, String> h) {
        this.parse(h);
    }

    public UCSCRefGene(String line) {
        this.parse_string(line);
    }

    public void parse_string(String line) {
        String[] fields = line.split("\t");
        if (fields.length == 16 || fields.length == 11 || fields.length == 13) {
            String[] f;
            int i = 0;
            this.bin = this.forgiving_parse_int(fields[i++], -1);
            this.name = new String(fields[i++]);
            this.chrom = new String(fields[i++]);
            this.strand = new String(fields[i++]);
            this.txStart = Integer.parseInt(fields[i++]);
            this.txEnd = Integer.parseInt(fields[i++]);
            this.cdsStart = Integer.parseInt(fields[i++]);
            this.cdsEnd = Integer.parseInt(fields[i++]);
            this.exonCount = Integer.parseInt(fields[i++]);
            this.exonStarts = this.parse_int_range(fields[i++]);
            this.exonEnds = this.parse_int_range(fields[i++]);
            if (fields.length >= 13) {
                this.score = this.forgiving_parse_int(fields[i++], -1);
                this.name2 = new String(fields[i++]);
            }
            if (fields.length >= 16) {
                this.cdsStartStat = new String(fields[i++]);
                this.cdsEndStat = new String(fields[i++]);
                this.exonFrames = this.parse_int_range(fields[i++]);
            }
            if (fields.length == 11 && this.name.indexOf(".") > 0 && (f = this.name.split("\\.")).length == 2) {
                this.name2 = new String(f[0]);
            }
        } else {
            System.err.println("ERROR: unknown format, expected 16 fields, has " + fields.length);
        }
    }

    public void parse(HashMap<String, String> row) {
        this.bin = Integer.parseInt(row.get("bin"));
        this.name = row.get("name");
        this.chrom = row.get("chrom");
        this.strand = row.get("strand");
        this.txStart = Integer.parseInt(row.get("txStart"));
        this.txEnd = Integer.parseInt(row.get("txEnd"));
        this.exonCount = Integer.parseInt(row.get("exonCount"));
        this.exonStarts = this.parse_int_range(row.get("exonStarts"));
        this.exonEnds = this.parse_int_range(row.get("exonEnds"));
        this.score = Integer.parseInt(row.get("score"));
        this.name2 = row.get("name2");
        this.cdsStartStat = row.get("cdsStartStat");
        this.cdsEndStat = row.get("cdsEndStat");
        this.exonFrames = this.parse_int_range(row.get("exonFrames"));
    }

    public static void main(String[] argv) {
        try {
            JDBCQuery ucsc = JDBCQuery.get_stjude_hg19();
            HashMap<String, String> hit = ucsc.query_single_row("refGene", "name2", "WRN");
            System.err.println("hit=" + hit);
            UCSCRefGene rg = new UCSCRefGene(hit);
            System.err.println(rg.name2);
            System.err.println(rg.exonStarts);
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
        }
    }

    private int[] parse_int_range(String range) {
        String[] ranges = range.split(",");
        int[] results = new int[ranges.length];
        for (int i = 0; i < ranges.length; ++i) {
            results[i] = Integer.parseInt(ranges[i]);
        }
        return results;
    }

    private int forgiving_parse_int(String v, int broken_value) {
        int result;
        if (v == null || v.length() == 0) {
            result = broken_value;
        } else {
            try {
                result = Integer.parseInt(v);
            }
            catch (NumberFormatException nfe) {
                result = broken_value;
            }
        }
        return result;
    }
}

