/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

import Funk.FileUtils;
import IsoView.UCSCRefGene;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UCSCRefGeneReader
implements Iterator,
Iterable<UCSCRefGene> {
    BufferedReader br;
    String next_line;
    HashMap<String, String> transcript2gene = null;

    public UCSCRefGeneReader(String file) throws FileNotFoundException, IOException {
        this.br = FileUtils.getUniversalBufferedReader(file);
        this.next_line = null;
    }

    public UCSCRefGeneReader(File file) throws FileNotFoundException, IOException {
        this.br = FileUtils.getUniversalBufferedReader(file);
        this.next_line = null;
    }

    public void parse(String file) throws FileNotFoundException, IOException {
        String line;
        while ((line = this.br.readLine()) != null) {
            UCSCRefGene rg = new UCSCRefGene(line);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.next_line == null) {
            try {
                this.next_line = this.br.readLine();
            }
            catch (Exception e) {
                System.err.println("ERROR reading from refgene file");
                this.next_line = null;
            }
        }
        return this.next_line != null;
    }

    public UCSCRefGene next() {
        UCSCRefGene rg = null;
        if (this.hasNext()) {
            rg = new UCSCRefGene(this.next_line);
            if (this.transcript2gene != null) {
                String lookup = this.transcript2gene.get(rg.name);
                if (lookup == null) {
                    System.err.println("WTF, can't find gene map for " + rg.name);
                } else {
                    rg.name2 = lookup;
                }
            }
            this.next_line = null;
        }
        return rg;
    }

    public void set_transcript2gene(String map_file) {
        this.transcript2gene = new HashMap();
        try {
            String line;
            BufferedReader br = FileUtils.getUniversalBufferedReader(map_file);
            while ((line = br.readLine()) != null) {
                String[] f = line.split("\t");
                if (f.length == 2) {
                    this.transcript2gene.put(f[0], f[1]);
                    continue;
                }
                System.err.println("transcript2gene format must be 2 fields");
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
        }
    }

    @Override
    public void remove() {
        System.err.println("remove() not implemented");
    }

    @Override
    public Iterator<UCSCRefGene> iterator() {
        return this;
    }

    public static void main(String[] argv) {
        try {
            UCSCRefGeneReader r = new UCSCRefGeneReader("ensGene.txt");
            r.set_transcript2gene("ensemblToGeneName.txt");
            for (UCSCRefGene rg : r) {
                System.err.println("read " + rg.name2);
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
        }
    }
}

