/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.AgilentParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgilentGlommer {
    public void process_files(ArrayList<String> files) {
        try {
            AgilentParser last_ap = null;
            for (String file : files) {
                System.err.println("parsing file " + file);
                AgilentParser ap = new AgilentParser(file);
                ArrayList<String> headers = ap.get_genome_markers();
                if (last_ap == null) {
                    System.out.print("Reporter");
                    for (int i = 0; i < headers.size(); ++i) {
                        System.out.print("\t");
                        System.out.print(headers.get(i));
                    }
                    System.out.println("");
                } else if (!ap.get_genome_markers().equals(last_ap.get_genome_markers())) {
                    throw new IOException("marker list doesn't match");
                }
                HashMap<String, Float> marker2value = ap.get_marker2value();
                System.out.print(file);
                for (int i = 0; i < headers.size(); ++i) {
                    System.out.print("\t");
                    Float fv = marker2value.get(headers.get(i));
                    double raw = Math.pow(10.0, fv.floatValue());
                    double log2 = Math.log(raw) / Math.log(2.0);
                    System.out.print(Math.round(log2));
                }
                System.out.println("");
                last_ap = ap;
            }
        }
        catch (Exception e) {
            System.err.println("error:" + e);
        }
    }

    public static void main(String[] argv) {
        ArrayList<String> files = new ArrayList<String>();
        files.add("07ER05488.txt.gz");
        files.add("07ES06177.txt.gz");
        files.add("07ES06294.txt.gz");
        files.add("07ES06734.txt.gz");
        files.add("07ES06798.txt.gz");
        files.add("07VA02686.txt.gz");
        files.add("07VA02818.txt.gz");
        files.add("07VA02843.txt.gz");
        files.add("07VA02864.txt.gz");
        files.add("07VA03129.txt.gz");
        files.add("07VA03140.txt.gz");
        files.add("07VA03153.txt.gz");
        files.add("07VA03202.txt.gz");
        files.add("07VA03261.txt.gz");
        files.add("07VA03279.txt.gz");
        files.add("07VA03328.txt.gz");
        files.add("07VA03360.txt.gz");
        files.add("07VA03416.txt.gz");
        files.add("07VA03483.txt.gz");
        files.add("07VA03484.txt.gz");
        files.add("07VA03498.txt.gz");
        files.add("07VA03595.txt.gz");
        files.add("07VA03596.txt.gz");
        files.add("07VA03603.txt.gz");
        files.add("07VA03611.txt.gz");
        files.add("07VA03622.txt.gz");
        files.add("07VA03623.txt.gz");
        files.add("07VA03715.txt.gz");
        files.add("07VA03725.txt.gz");
        files.add("07VA03783.txt.gz");
        AgilentGlommer ag = new AgilentGlommer();
        ag.process_files(files);
    }
}

