/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.AgilentBlock;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgilentParser {
    private BufferedReader br;
    private ArrayList<AgilentBlock> blocks;
    private ArrayList<String> genome_markers;
    private HashMap<String, Float> marker2value;

    public AgilentParser(String fn) throws FileNotFoundException, IOException {
        this.br = fn.lastIndexOf(".gz") == fn.length() - 3 ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(fn)))) : new BufferedReader(new FileReader(fn));
        this.setup();
    }

    public void parse(BufferedReader br) throws IOException {
        String line;
        this.blocks = new ArrayList();
        AgilentBlock ab_data_type = null;
        AgilentBlock ab_headers = null;
        HashSet[] chr2marker = new HashSet[25];
        for (int i = 0; i <= 24; ++i) {
            chr2marker[i] = new HashSet();
        }
        this.marker2value = new HashMap();
        while ((line = br.readLine()) != null) {
            String[] f = line.split("\t");
            AgilentBlock ab = new AgilentBlock(f);
            String name = ab.get_name();
            if (name.equals("TYPE")) {
                ab_data_type = ab;
                continue;
            }
            if (name.equals("DATA")) {
                if (ab_headers.get_name().equals("FEATURES")) {
                    String gene = ab.get(ab_headers.get_index_of("GeneName"));
                    if (!gene.substring(0, 3).equals("chr")) continue;
                    String[] g = gene.split(":");
                    String chr_s = g[0].substring(3);
                    int chr_i = chr_s.equals("X") ? 23 : (chr_s.equals("Y") ? 24 : Integer.parseInt(chr_s));
                    Float fv = Float.valueOf(Float.parseFloat(ab.get(ab_headers.get_index_of("LogRatio"))));
                    chr2marker[chr_i].add(gene);
                    this.marker2value.put(gene, fv);
                    continue;
                }
                System.err.println("skipping data for " + ab_headers.get_name());
                continue;
            }
            ab_headers = ab;
            ab_headers.build_index();
        }
        this.genome_markers = new ArrayList();
        for (int ci = 1; ci <= 24; ++ci) {
            if (chr2marker[ci].size() <= 0) continue;
            ArrayList markers = new ArrayList(chr2marker[ci]);
            Collections.sort(markers);
            this.genome_markers.addAll(markers);
        }
    }

    private void setup() throws IOException {
        this.parse(this.br);
    }

    public static void main(String[] argv) {
        try {
            String fn = "07ER05488.txt.gz";
            AgilentParser agilentParser = new AgilentParser(fn);
        }
        catch (Exception e) {
            System.err.println("ERROR:" + e);
        }
    }

    public ArrayList<String> get_genome_markers() {
        return this.genome_markers;
    }

    public HashMap<String, Float> get_marker2value() {
        return this.marker2value;
    }
}

