/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import Funk.Str;
import TCGA.AnnotationFlatfile2;
import TCGA.GenomicMeasurement;
import TCGA.GenomicSample;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class AnnotationColorMapper2 {
    private Color max_color;
    private AnnotationFlatfile2 af;
    private Hashtable maps_keyed = null;
    private Hashtable maps_scale;
    private int max_r;
    private int max_g;
    private int max_b;
    private HashSet integer_columns = null;
    private static HashSet undef_cell_values = AnnotationColorMapper2.init_undef_values();
    public static Color UNDEF_COLOR = Color.gray;

    public AnnotationColorMapper2(AnnotationFlatfile2 af, Color max_color) {
        this.af = af;
        this.max_r = max_color.getRed();
        this.max_g = max_color.getGreen();
        this.max_b = max_color.getBlue();
        this.setup();
    }

    private void setup() {
        this.integer_columns = new HashSet();
        this.maps_scale = new Hashtable();
        this.maps_keyed = new Hashtable();
        Vector rows = this.af.get_rows();
        Hashtable first = (Hashtable)rows.get(0);
        ArrayList columns = this.af.get_sorted_keys();
        for (int i = 0; i < columns.size(); ++i) {
            String column = (String)columns.get(i);
            Str.trim_whitespace(column);
            if (column.length() == 0) continue;
            boolean is_integer = true;
            HashSet<String> all_values = new HashSet<String>();
            int max_value = 0;
            for (int j = 0; j < rows.size(); ++j) {
                Hashtable h = (Hashtable)rows.get(j);
                String value = (String)h.get(column);
                if (value != null) {
                    value = Str.trim_whitespace(value);
                }
                if (!AnnotationColorMapper2.is_usable_value(value)) continue;
                all_values.add(value);
                if (!is_integer) continue;
                try {
                    int v = Math.abs(Integer.parseInt(value));
                    if (v <= max_value) continue;
                    max_value = v;
                    continue;
                }
                catch (NumberFormatException e) {
                    is_integer = false;
                }
            }
            if (is_integer) {
                this.integer_columns.add(column);
                this.maps_scale.put(column, new Float(1.0f / (float)max_value));
                continue;
            }
            Hashtable<String, Float> ht = null;
            ArrayList unique = new ArrayList(all_values);
            Collections.sort(unique);
            boolean yesno_only = true;
            for (String val : unique) {
                String lc = val.toLowerCase();
                if (lc.equals("yes") || lc.equals("no")) continue;
                yesno_only = false;
                break;
            }
            ht = new Hashtable<String, Float>();
            if (yesno_only) {
                Iterator i$ = unique.iterator();
                while (i$.hasNext()) {
                    String v2;
                    ht.put(v2, Float.valueOf((v2 = (String)i$.next()).toLowerCase().equals("yes") ? 1.0f : 0.0f));
                }
            } else {
                float step;
                float fv;
                int size = unique.size();
                if (size <= 1) {
                    fv = size;
                    step = size;
                } else {
                    fv = 0.0f;
                    step = 1.0f / (float)(size - 1);
                }
                int k = 0;
                while (k < size) {
                    ht.put((String)unique.get(k), new Float(fv));
                    ++k;
                    fv += step;
                }
            }
            this.maps_keyed.put(column, ht);
        }
    }

    public Color get_color(String field, String value) {
        Color result = UNDEF_COLOR;
        Hashtable map = (Hashtable)this.maps_keyed.get(field);
        if (value != null) {
            value = Str.trim_whitespace(value);
        }
        if (!AnnotationColorMapper2.is_usable_value(value)) {
            result = UNDEF_COLOR;
        } else if (map != null) {
            Float modifier = (Float)map.get(value);
            if (modifier != null) {
                Float f = Float.valueOf(modifier.floatValue());
                int r = (int)((float)this.max_r * f.floatValue());
                int g = (int)((float)this.max_g * f.floatValue());
                int b = (int)((float)this.max_b * f.floatValue());
                result = new Color(r, g, b);
            }
        } else {
            Float f = (Float)this.maps_scale.get(field);
            if (f != null) {
                int r = 0;
                int g = 0;
                int b = 0;
                int v = 0;
                try {
                    if (value.equals("")) {
                        value = "0";
                    }
                    v = Math.abs(Integer.parseInt(value));
                    Float multiplier = Float.valueOf((float)v * f.floatValue());
                    r = (int)((float)this.max_r * multiplier.floatValue());
                    g = (int)((float)this.max_g * multiplier.floatValue());
                    b = (int)((float)this.max_b * multiplier.floatValue());
                    result = new Color(r, g, b);
                }
                catch (Exception e) {
                    System.err.println("color mapping exception for field:" + field + " " + e + " val=" + v + " r=" + r + " g=" + g + " b=" + b);
                }
            }
        }
        return result;
    }

    public static void main(String[] argv) {
        try {
            AnnotationFlatfile2 af = new AnnotationFlatfile2("gbm_sample_data.tab", false);
            AnnotationColorMapper2 annotationColorMapper2 = new AnnotationColorMapper2(af, Color.yellow);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public void sort_samples_by(String field, GenomicMeasurement gm, AnnotationFlatfile2 af) {
        boolean is_integer = this.integer_columns.contains(field);
        ArrayList<GenomicSample> gm_rows = gm.get_rows();
        System.err.println("FIX ME: annotation sort; visible rows???");
        HashSet<Object> unique_values = new HashSet<Object>();
        ArrayList<GenomicSample> invalid_samples = new ArrayList<GenomicSample>();
        HashMap<String, ArrayList<GenomicSample>> bucket = new HashMap<String, ArrayList<GenomicSample>>();
        for (GenomicSample gs : gm_rows) {
            ArrayList annot = af.find_annotations(gs);
            if (annot == null) {
                invalid_samples.add(gs);
                continue;
            }
            Hashtable ht = (Hashtable)annot.get(0);
            String value = (String)ht.get(field);
            if (AnnotationColorMapper2.is_usable_value(value)) {
                if (is_integer) {
                    unique_values.add(new Integer(Integer.parseInt(value)));
                } else {
                    unique_values.add(value);
                }
                ArrayList<GenomicSample> b2 = (ArrayList<GenomicSample>)bucket.get(value);
                if (b2 == null) {
                    b2 = new ArrayList<GenomicSample>();
                    bucket.put(value, b2);
                }
                b2.add(gs);
                continue;
            }
            invalid_samples.add(gs);
        }
        ArrayList sorted = new ArrayList(unique_values);
        Collections.sort(sorted);
        ArrayList<GenomicSample> results = new ArrayList<GenomicSample>();
        for (int i = 0; i < sorted.size(); ++i) {
            String key = sorted.get(i).toString();
            ArrayList list = (ArrayList)bucket.get(key);
            results.addAll(list);
        }
        results.addAll(invalid_samples);
        gm.set_rows(results, true);
    }

    public static boolean is_usable_value(String value) {
        return value != null && value.length() > 0 && !undef_cell_values.contains(value.toUpperCase());
    }

    private static HashSet init_undef_values() {
        HashSet<String> undef = new HashSet<String>();
        undef.add("-");
        undef.add("NASS");
        undef.add("UNKNOWN");
        undef.add("NOT COMPUTABLE");
        undef.add("NULL");
        undef.add("null");
        return undef;
    }

    public static HashSet get_undef_values() {
        return undef_cell_values;
    }
}

