/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import Funk.DelimitedFile;
import TCGA.AnnotationColorMapper2;
import TCGA.CommentSection;
import TCGA.GenomicMeasurement;
import TCGA.GenomicSample;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Observable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationFlatfile2
extends Observable
implements Runnable {
    private boolean is_loaded = false;
    private InputStream input_stream = null;
    private Vector rows = null;
    private ArrayList<String> filtered_columns = null;
    private DelimitedFile df;
    private String local_filename = null;
    private InputStream ins = null;
    private Exception parse_exception = null;
    private String barcode_column = null;
    private ArrayList sorted_keys = null;
    private HashMap<String, ArrayList> by_barcode;
    private ArrayList<CommentSection> sections = null;
    private HashMap<String, String> column2section = null;

    public AnnotationFlatfile2(String fn) throws Exception {
        this.local_filename = fn;
        new Thread(this).start();
    }

    public AnnotationFlatfile2(String fn, boolean async) throws Exception {
        this.local_filename = fn;
        if (async) {
            new Thread(this).start();
        } else {
            this.run();
        }
    }

    public AnnotationFlatfile2(InputStream ins, boolean async) throws Exception {
        this.ins = ins;
        if (async) {
            new Thread(this).start();
        } else {
            this.run();
        }
    }

    public AnnotationFlatfile2(InputStream ins) throws Exception {
        this.ins = ins;
        new Thread(this).start();
    }

    public boolean is_loaded() {
        return this.is_loaded;
    }

    public Vector get_rows() {
        return this.rows;
    }

    public ArrayList get_sorted_keys() {
        if (this.sorted_keys == null && this.is_loaded) {
            this.sorted_keys = new ArrayList<String>(this.filtered_columns);
            Collections.sort(this.sorted_keys);
        }
        return this.sorted_keys;
    }

    public Exception get_parse_exception() {
        return this.parse_exception;
    }

    public int get_row_count() {
        return this.rows == null ? -1 : this.rows.size();
    }

    @Override
    public void run() {
        this.df = null;
        this.parse_exception = null;
        try {
            this.df = new DelimitedFile();
            this.df.set_filter_unix_comments(true);
            this.df.set_trim_whitespace(true);
            this.df.set_standardize_dates(true);
            this.df.set_standardize_labels(false);
            if (this.local_filename != null) {
                this.df.parse(this.local_filename);
            } else if (this.ins != null) {
                this.df.parse(this.ins);
            } else {
                System.err.println("ERROR: no annotation flatfile");
                System.exit(1);
            }
        }
        catch (Exception e) {
            this.parse_exception = e;
            System.err.println(e);
        }
        if (this.parse_exception == null) {
            this.rows = this.df.get_rows();
            this.filtered_columns = this.column_setup();
            this.section_setup();
        } else {
            this.filtered_columns = new ArrayList();
        }
        this.is_loaded = true;
        this.setChanged();
        this.notifyObservers();
    }

    private ArrayList<String> column_setup() {
        HashMap col_values = new HashMap();
        ArrayList<String> columns = new ArrayList<String>();
        for (Object o : this.df.get_labels()) {
            String col = (String)o;
            col_values.put(col, new HashSet());
            columns.add(col);
        }
        for (Object r : this.rows) {
            Hashtable row = (Hashtable)r;
            for (String col : columns) {
                String v = (String)row.get(col);
                if (v == null) {
                    v = "";
                }
                ((HashSet)col_values.get(col)).add(v);
            }
        }
        HashSet undefs = AnnotationColorMapper2.get_undef_values();
        ArrayList<String> rejected = new ArrayList<String>();
        for (String col : columns) {
            HashSet bucket = (HashSet)col_values.get(col);
            if (bucket.size() != 1) continue;
            String value = "";
            Iterator i$ = bucket.iterator();
            while (i$.hasNext()) {
                String x;
                value = x = (String)i$.next();
            }
            if (undefs.contains(value)) {
                System.err.println("rejecting static annotation column " + col + ": only value is " + value);
                rejected.add(col);
                continue;
            }
            System.err.println("keeping single-value column " + col + ": value is \"" + value + "\"");
        }
        columns.removeAll(rejected);
        return columns;
    }

    public String[] get_annotation_columns() {
        ArrayList<String> use = new ArrayList<String>();
        use.addAll(this.filtered_columns);
        use.remove(this.barcode_column);
        String[] results = new String[use.size()];
        for (int i = 0; i < use.size(); ++i) {
            results[i] = (String)use.get(i);
        }
        return results;
    }

    public void index_annotations(GenomicMeasurement gm) {
        HashSet<String> patient_ids = new HashSet<String>(gm.get_visible_sample_ids());
        Vector columns = this.df.get_labels();
        this.barcode_column = null;
        for (int ri = 0; ri < this.rows.size(); ++ri) {
            Hashtable row = (Hashtable)this.rows.get(ri);
            for (int i = 0; i < columns.size(); ++i) {
                String column = (String)columns.get(i);
                String value = (String)row.get(column);
                if (value == null || !patient_ids.contains(value)) continue;
                this.barcode_column = column;
                break;
            }
            if (this.barcode_column != null) break;
        }
        if (this.barcode_column != null) {
            this.by_barcode = this.build_index(this.barcode_column);
        } else {
            System.err.println("ERROR: can't detect sample ID column in annotation file!");
        }
    }

    private HashMap build_index(String field) {
        Enumeration e = this.rows.elements();
        HashMap<String, ArrayList<Hashtable>> map = new HashMap<String, ArrayList<Hashtable>>();
        while (e.hasMoreElements()) {
            Hashtable r = (Hashtable)e.nextElement();
            String v = (String)r.get(field);
            ArrayList<Hashtable> al = (ArrayList<Hashtable>)map.get(v);
            if (al == null) {
                al = new ArrayList<Hashtable>();
                map.put(v, al);
            }
            al.add(r);
        }
        return map;
    }

    public ArrayList find_annotations(GenomicSample gs) {
        return this.by_barcode.get(gs.patient_id);
    }

    public static void main(String[] argv) {
        try {
            AnnotationFlatfile2 af = new AnnotationFlatfile2("gbm_sample_data.tab", false);
            GenomicSample gs = new GenomicSample();
            gs.patient_id = "TCGA-02-0116";
            ArrayList al = af.find_annotations(gs);
            System.err.println("found: " + al);
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            new Exception().printStackTrace();
        }
    }

    private void section_setup() {
        ArrayList<String> comments = this.df.get_unix_comments();
        if (comments != null && comments.size() > 0) {
            for (String comment : comments) {
                String[] chunks = comment.split("=");
                if (chunks.length != 2) continue;
                if (chunks[0].equals("#section")) {
                    if (this.sections == null) {
                        this.sections = new ArrayList();
                    }
                    this.sections.add(new CommentSection(chunks[1].split(",")));
                    continue;
                }
                System.err.println("ERROR: " + chunks[0]);
            }
        }
        if (this.sections != null) {
            this.column2section = new HashMap();
            for (CommentSection cs : this.sections) {
                for (String label : cs.labels) {
                    this.column2section.put(label, cs.section_name);
                }
            }
        }
    }

    public HashMap<String, String> get_column2section() {
        return this.column2section;
    }
}

