/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.AnnotationColorMapper2;
import TCGA.AnnotationDisplayControl;
import TCGA.AnnotationFlatfile2;
import TCGA.AnnotationGridData;
import TCGA.ChromDecoratorPanel;
import TCGA.GenomicMeasurement;
import TCGA.GenomicSample;
import TCGA.HelpLauncher;
import TCGA.PopupListener;
import TCGA.Range;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class AnnotationGridPanel2
extends JPanel
implements AdjustmentListener,
MouseListener,
ActionListener,
Observer {
    private GenomicMeasurement gm;
    private ChromDecoratorPanel isp = null;
    private HashSet<String> visible_annotations = null;
    private float ROW_HEIGHT = 6.0f;
    private int column_width;
    private int column_y_buf;
    private AnnotationDisplayControl adc;
    private static Color annotation_color = Color.yellow;
    private int grid_height = 0;
    private static final String LABEL_HELP = "Help: annotations";
    private static final int FONT_SIZE = 12;
    ArrayList<AnnotationGridData> annotations = new ArrayList();

    public AnnotationGridPanel2(AnnotationFlatfile2 af, AnnotationFlatfile2 vasari, GenomicMeasurement gm, ChromDecoratorPanel isp) {
        if (af != null) {
            this.annotations.add(new AnnotationGridData(af, annotation_color));
        }
        if (vasari != null) {
            this.annotations.add(new AnnotationGridData(vasari, annotation_color));
        }
        this.gm = gm;
        this.isp = isp;
        this.reset_fields();
        this.ROW_HEIGHT = isp == null ? 6.0f : isp.get_vertical_scale_level();
        Font font = this.get_font();
        FontMetrics fm = this.getFontMetrics(font);
        this.column_width = (int)((double)fm.getHeight() * 1.3);
        this.column_y_buf = (this.column_width - fm.getHeight()) / 2;
        Dimension pref = new Dimension(this.get_column_count() * this.column_width, this.getPreferredSize().height);
        this.setPreferredSize(pref);
        this.addMouseListener(this);
        this.setToolTipText("field name");
        JPopupMenu jpm = new JPopupMenu();
        JMenuItem jmi = new JMenuItem("Choose annotations to display...");
        jpm.add(jmi);
        jmi.addActionListener(this);
        jpm.add(new JSeparator());
        jpm.add(HelpLauncher.generate_jmenuitem(LABEL_HELP, "panel_annotations"));
        new PopupListener(this, jpm);
    }

    public void set_grid_height(int h) {
        this.grid_height = h;
    }

    protected void paintComponent(Graphics gr) {
        int y;
        int start;
        ArrayList<GenomicSample> gm_rows = this.gm.get_visible_rows();
        super.paintComponent(gr);
        Dimension d = this.getSize();
        Graphics2D g = (Graphics2D)gr;
        boolean row = false;
        if (this.isp == null) {
            start = 0;
            this.grid_height = 300;
        } else {
            start = this.isp.get_unscaled_y_start();
            this.grid_height = this.isp.getSize().height;
        }
        int end = gm_rows.size();
        float yf = 0.0f;
        for (int i = start; i < end; ++i) {
            y = (int)yf;
            int y2 = (int)(yf + this.ROW_HEIGHT);
            int height = y2 - y + 1;
            if (y2 >= this.grid_height) break;
            GenomicSample gs = gm_rows.get(i);
            int screen_col = 0;
            for (AnnotationGridData agd : this.annotations) {
                int flen = agd.visible_fields.size();
                ArrayList annot = agd.af.find_annotations(gs);
                if (annot == null) {
                    g.setColor(AnnotationColorMapper2.UNDEF_COLOR);
                    g.fillRect(screen_col * this.column_width, y, flen * this.column_width, height);
                    screen_col += flen;
                    continue;
                }
                Hashtable ht = (Hashtable)annot.get(0);
                int col = 0;
                while (col < flen) {
                    String field = agd.visible_fields.get(col);
                    g.setColor(agd.acm.get_color(field, (String)ht.get(field)));
                    g.fillRect(screen_col * this.column_width, y, this.column_width, height);
                    ++col;
                    ++screen_col;
                }
            }
            yf += this.ROW_HEIGHT;
        }
        Graphics2D g2 = g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Font font = this.get_font();
        FontMetrics fm = this.getFontMetrics(font);
        int buffer = 5;
        int base_y = (int)yf + buffer;
        int max_y = 0;
        AffineTransform at = new AffineTransform();
        at.rotate(-1.5707963267948966, 0.0, 0.0);
        Font derived = font.deriveFont(at);
        if (derived == null) {
            System.err.println("ERROR deriving vertical font!");
        }
        g2.setFont(derived);
        g2.setPaint(Color.blue);
        int screen_col = 0;
        boolean has_sections = false;
        HashMap<String, Range> section2cols = new HashMap<String, Range>();
        int max_x = 0;
        for (AnnotationGridData agd : this.annotations) {
            HashMap<String, String> column2section = agd.get_af().get_column2section();
            if (column2section != null) {
                has_sections = true;
            }
            agd.index2field = new HashMap();
            for (String label : agd.visible_fields) {
                int x;
                int x_raw = screen_col * this.column_width;
                max_x = x = x_raw + this.column_y_buf + fm.getAscent();
                if (column2section != null) {
                    String section = column2section.get(label);
                    if (section == null) {
                        System.err.println("WTF: " + label);
                    } else {
                        Range r = (Range)section2cols.get(section);
                        if (r == null) {
                            r = new Range(-1, -1);
                            section2cols.put(section, r);
                        }
                        if (r.start == -1 || x_raw < r.start) {
                            r.start = x_raw;
                        }
                        if (r.end == -1 || x_raw > r.end) {
                            r.end = x_raw;
                        }
                    }
                }
                if ((y = base_y + fm.stringWidth(label)) > max_y) {
                    max_y = y;
                }
                g2.drawString(label, x, y);
                agd.index2field.put(screen_col, label);
                ++screen_col;
            }
        }
        g2.setColor(AnnotationColorMapper2.UNDEF_COLOR);
        g2.fillRect(0, max_y + 1, max_x + this.column_width, max_y + fm.getHeight() * 2);
        Font f = this.get_font();
        fm = this.getFontMetrics(f);
        g2.setFont(f);
        for (String section : section2cols.keySet()) {
            Range r = (Range)section2cols.get(section);
            g2.setColor(new Color(100, 100, 100));
            g2.drawLine(r.start, base_y, r.start, max_y);
            int width = r.end - r.start + this.column_width;
            int x_center = r.start + width / 2;
            int sw = fm.stringWidth(section);
            int sy = max_y + fm.getHeight();
            g2.setColor(Color.white);
            g2.drawString(section, x_center - sw / 2, sy);
        }
        max_y += buffer;
        if (has_sections) {
            max_y += fm.getHeight();
        }
        if (max_y > d.height) {
            d.height = max_y;
            this.setSize(d);
            this.setPreferredSize(d);
            this.invalidate();
        }
    }

    public static void main(String[] argv) {
        try {
            AnnotationFlatfile2 af = new AnnotationFlatfile2("GBM_sample_data.tab", false);
            if (argv.length == 0) {
                System.err.println("ERROR: specify gm file");
            } else {
                String gm_fn = argv[0];
                GenomicMeasurement gm = new GenomicMeasurement(gm_fn, false);
                JFrame jf = new JFrame();
                jf.setDefaultCloseOperation(3);
                jf.setLayout(new BorderLayout());
                AnnotationGridPanel2 agp = new AnnotationGridPanel2(af, null, gm, null);
                jf.add("Center", agp);
                jf.pack();
                jf.setVisible(true);
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
        }
    }

    public void set_vertical_scale_level(float v) {
        this.ROW_HEIGHT = v;
        this.repaint();
    }

    public float get_vertical_scale_level() {
        return this.ROW_HEIGHT;
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        Point p = e.getPoint();
        int index = p.x / this.column_width;
        for (AnnotationGridData agd : this.annotations) {
            String field = agd.index2field.get(index);
            if (field == null) continue;
            agd.acm.sort_samples_by(field, this.gm, agd.af);
            if (this.isp != null) {
                this.isp.set_tooltip_field(field);
            }
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public String getToolTipText(MouseEvent e) {
        Point mp = e.getPoint();
        int index = mp.x / this.column_width;
        String result = "";
        int col_count = this.get_column_count();
        ArrayList<GenomicSample> gm_rows = this.gm.get_visible_rows();
        int sample_index = this.isp == null ? 0 : this.isp.get_unscaled_y_start();
        sample_index += (int)((float)mp.y / this.ROW_HEIGHT);
        String field = null;
        for (AnnotationGridData agd : this.annotations) {
            field = agd.index2field.get(index);
            if (field == null) continue;
            if (sample_index < gm_rows.size()) {
                Hashtable ht;
                String value;
                GenomicSample gs = gm_rows.get(sample_index);
                String value_label = "(no data)";
                ArrayList annot = agd.af.find_annotations(gs);
                if (annot != null && AnnotationColorMapper2.is_usable_value(value = (String)(ht = (Hashtable)annot.get(0)).get(field))) {
                    value_label = value;
                }
                result = field + ": " + value_label;
            } else {
                result = field;
            }
            result = result.concat(" (click to sort)");
            break;
        }
        return result;
    }

    private Font get_font() {
        return new Font("SansSerif", 0, 12);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.adc == null) {
            ArrayList<String> fields = new ArrayList<String>();
            for (AnnotationGridData annot : this.annotations) {
                fields.addAll(annot.af.get_sorted_keys());
            }
            Collections.sort(fields);
            this.adc = new AnnotationDisplayControl(fields);
            this.adc.addObserver(this);
        } else {
            this.adc.setVisible(true);
        }
    }

    public void update(Observable o, Object arg) {
        this.visible_annotations = new HashSet((ArrayList)arg);
        this.reset_fields();
        this.repaint();
    }

    private void reset_fields() {
        for (AnnotationGridData agd : this.annotations) {
            this.reset_field_set(agd);
        }
    }

    private void reset_field_set(AnnotationGridData agd) {
        String[] all = agd.af.get_annotation_columns();
        agd.visible_fields = new ArrayList();
        for (int i = 0; i < all.length; ++i) {
            if (this.visible_annotations != null && !this.visible_annotations.contains(all[i])) continue;
            agd.visible_fields.add(all[i]);
        }
    }

    private String[] reset_field_set(AnnotationFlatfile2 ff, boolean is_vasari) {
        HashSet<String> vis;
        ArrayList<String> fields_all = new ArrayList<String>();
        String[] all = ff.get_annotation_columns();
        for (int i = 0; i < all.length; ++i) {
            fields_all.add(all[i]);
        }
        if (is_vasari) {
            fields_all.remove("Sample_3");
            fields_all.remove("Sample_4");
            fields_all.remove("Sample_5");
        }
        if ((vis = this.visible_annotations) == null) {
            vis = new HashSet();
            for (int i = 0; i < all.length; ++i) {
                vis.add(all[i]);
            }
        }
        int visible = 0;
        for (String field : fields_all) {
            if (!vis.contains(field)) continue;
            ++visible;
        }
        String[] fields = new String[visible];
        int j = 0;
        for (String field : fields_all) {
            if (!vis.contains(field)) continue;
            fields[j++] = field;
        }
        return fields;
    }

    private int get_column_count() {
        int count = 0;
        for (AnnotationGridData agd : this.annotations) {
            count += agd.visible_fields.size();
        }
        return count;
    }
}

