/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.AnnotationFlatfile2;
import TCGA.GenomicMeasurement;
import TCGA.GenomicSample;
import TCGA.ImageScalePanel2;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class AnnotationViewer
implements MouseListener,
MouseMotionListener {
    private AnnotationFlatfile2 af;
    private GenomicMeasurement gm;
    private ImageScalePanel2 isp;
    private JTable table;
    private static int ROW_COUNT = 115;

    public AnnotationViewer(AnnotationFlatfile2 af, GenomicMeasurement gm, ImageScalePanel2 isp) {
        this.af = af;
        this.gm = gm;
        this.isp = isp;
        this.setup();
    }

    private void setup() {
        JFrame jf = new JFrame("Annotation Viewer");
        JPanel jp = new JPanel(new GridLayout(1, 0));
        this.table = new JTable(this.af.get_row_count(), 2);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 70));
        DefaultTableModel tm = (DefaultTableModel)this.table.getModel();
        Object[] labels = new String[]{"Label", "Value"};
        tm.setColumnIdentifiers(labels);
        JScrollPane scrollPane = new JScrollPane(this.table);
        jp.add(scrollPane);
        this.isp.addMouseListener(this);
        jf.add(jp);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        try {
            jf.setPreferredSize(new Dimension((int)((double)screen.width * 0.3), (int)((double)screen.height * 0.95)));
        }
        catch (NoSuchMethodError e) {
            System.err.println("can't set pref JFrame size on this JVM");
        }
        jf.pack();
        jf.setVisible(true);
    }

    public void display_row(Hashtable row) {
        ArrayList keys = this.af.get_sorted_keys();
        int ri = 0;
        for (String key : keys) {
            this.table.setValueAt(key, ri, 0);
            this.table.setValueAt(row.get(key), ri++, 1);
        }
    }

    public void clear_table(String id) {
        this.table.setValueAt("ERROR: no annotations found!", 0, 0);
        this.table.setValueAt(id, 0, 1);
        for (int ri = 1; ri < this.af.get_row_count(); ++ri) {
            this.table.setValueAt("", ri, 0);
            this.table.setValueAt("", ri, 1);
        }
    }

    private void show_annotations(Point mp) {
        if (this.af.is_loaded() && this.gm.is_loaded()) {
            GenomicSample gs;
            ArrayList annot;
            Point p = this.isp.get_unscaled_point(mp);
            int index = p.y;
            ArrayList<GenomicSample> gm_rows = this.gm.get_visible_rows();
            if (index >= gm_rows.size()) {
                index = gm_rows.size() - 1;
            }
            if ((annot = this.af.find_annotations(gs = gm_rows.get(index))) != null) {
                Hashtable row = (Hashtable)annot.get(0);
                this.display_row(row);
            } else {
                this.clear_table(gs.patient_id);
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        this.show_annotations(e.getPoint());
    }

    public void mouseClicked(MouseEvent e) {
        this.show_annotations(e.getPoint());
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

