/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import Funk.LookAndFeeler;
import TCGA.GenomicMeasurement;
import TCGA.GenomicSet;
import TCGA.JButtonGenerator;
import TCGA.SampleSortTools;
import TCGA.SampleSubsets;
import TCGA.VisibilityToggle;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import layout.SpringUtilities;

public class ClusterControl
implements ActionListener,
VisibilityToggle {
    private JFrame jf;
    private JComboBox jc_multi;
    private JComboBox jc_subsets;
    private JComboBox jc_cluster_values;
    private JCheckBox jx_rearrange;
    private JTextField tf_threshold;
    private GenomicMeasurement gm;
    private GenomicSet gs;
    private SampleSubsets sample_subsets;
    private static final String LABEL_OK = "OK";
    private static final String LABEL_CANCEL = "Cancel";

    public ClusterControl() {
        this.setup();
    }

    public ClusterControl(GenomicMeasurement gm, GenomicSet gs) {
        this.gm = gm;
        this.gs = gs;
        this.sample_subsets = gm.get_sample_subsets();
        this.setup();
    }

    private void setup() {
        this.jf = new JFrame();
        this.jf.setTitle("Cluster control");
        JPanel jp_main = new JPanel();
        jp_main.setLayout(new BoxLayout(jp_main, 3));
        JPanel jp_controls = new JPanel();
        jp_controls.setLayout(new SpringLayout());
        Vector<String> subsets = new Vector<String>();
        subsets.add(SampleSortTools.CLUSTER_SUBSET_ALL);
        if (this.sample_subsets != null) {
            subsets.addAll(this.sample_subsets.get_visible_subsets());
        }
        this.jc_subsets = new JComboBox(subsets);
        jp_controls.add(new JLabel("subset to base clustering on:", 11));
        jp_controls.add(this.jc_subsets);
        jp_controls.add(new JLabel("values to cluster by:", 11));
        Vector<String> cluster_values = new Vector<String>();
        cluster_values.add(SampleSortTools.CLUSTER_VALUE_ANY);
        cluster_values.add(SampleSortTools.CLUSTER_VALUE_POSITIVE);
        cluster_values.add(SampleSortTools.CLUSTER_VALUE_NEGATIVE);
        this.jc_cluster_values = new JComboBox(cluster_values);
        jp_controls.add(this.jc_cluster_values);
        jp_controls.add(new JLabel("minimum value to cluster:", 11));
        this.tf_threshold = new JTextField("1.0");
        jp_controls.add(this.tf_threshold);
        jp_controls.add(new JLabel("if multiple rows per sample, use:", 11));
        Vector<String> multi = new Vector<String>();
        multi.add(SampleSortTools.AVERAGE_VALUE);
        multi.add(SampleSortTools.HIGHEST_ABSOLUTE_VALUE);
        this.jc_multi = new JComboBox(multi);
        jp_controls.add(this.jc_multi);
        jp_controls.add(new JLabel("rearrange columns after clustering?:", 11));
        this.jx_rearrange = new JCheckBox();
        jp_controls.add(this.jx_rearrange);
        this.jx_rearrange.setSelected(true);
        SpringUtilities.makeCompactGrid((Container)jp_controls, (int)5, (int)2, (int)6, (int)6, (int)6, (int)6);
        JPanel jp_buttons = new JPanel();
        JButtonGenerator jbg = new JButtonGenerator(this, jp_buttons);
        jbg.generate_jbutton(LABEL_OK);
        jbg.generate_jbutton(LABEL_CANCEL);
        jp_main.add(jp_controls);
        jp_main.add(jp_buttons);
        this.jf.getContentPane().add(jp_main);
        this.jf.pack();
    }

    public void setVisible(boolean v) {
        this.jf.setVisible(v);
    }

    public void actionPerformed(ActionEvent e) {
        String label;
        Object src = e.getSource();
        if (src instanceof AbstractButton && (label = ((AbstractButton)src).getText()).equals(LABEL_OK)) {
            float threshold = Float.parseFloat(this.tf_threshold.getText());
            SampleSortTools sst = new SampleSortTools(this.gm, this.gs);
            sst.set_minimum_value_to_cluster(threshold);
            sst.set_rearrange_columns(this.jx_rearrange.isSelected());
            sst.set_multi_sample_representative_method((String)this.jc_multi.getSelectedItem());
            sst.set_subset_filter((String)this.jc_subsets.getSelectedItem());
            sst.set_value_filter((String)this.jc_cluster_values.getSelectedItem());
            sst.sort_by_cluster();
        }
        this.jf.setVisible(false);
        this.jf.dispose();
    }

    public static void main(String[] argv) {
        LookAndFeeler.set_native_lookandfeel();
        ClusterControl cc = new ClusterControl();
    }
}

