/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.Cluster;
import TCGA.ClusterReporter;
import TCGA.DoubleHashMap;
import TCGA.GenomicMeasurement;
import TCGA.GenomicSample;
import TCGA.PearsonRCluster;
import TCGA.ProgressFrame;
import TCGA.SampleSortTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterTool
extends Observable
implements Runnable,
Observer {
    private GenomicMeasurement gm;
    private double[][] distance_matrix;
    private double cluster_stop_threshold;
    private int distance_method = 1;
    private Cluster control_cluster = null;
    private boolean separate_null_leftovers;
    private boolean report_results;
    private int visible_in_clusters;
    private boolean wants_zoom;
    private boolean matrix_build_cancelled;
    private ArrayList<Cluster> cluster_list_final;
    private ArrayList<GenomicSample> last_rows;

    public ClusterTool(GenomicMeasurement gm) {
        this.gm = gm;
    }

    public void set_distance_method(int method) {
        this.distance_method = method;
    }

    public int get_distance_method() {
        return this.distance_method;
    }

    public void set_wants_zoom(boolean z) {
        this.wants_zoom = z;
    }

    public int get_visible_in_clusters() {
        return this.visible_in_clusters;
    }

    public boolean wants_zoom() {
        return this.wants_zoom;
    }

    @Override
    public void run() {
        this.do_cluster();
    }

    public void cluster(Cluster control_cluster, boolean separate_null_leftovers, boolean report_results) {
        this.control_cluster = control_cluster;
        this.separate_null_leftovers = separate_null_leftovers;
        this.report_results = report_results;
        new Thread(this).start();
    }

    public void set_cluster_stop_threshold(double r) {
        this.cluster_stop_threshold = r;
    }

    public double get_cluster_stop_threshold() {
        return this.cluster_stop_threshold;
    }

    private void do_cluster() {
        int csize;
        int j;
        int i;
        boolean cache_ok;
        ArrayList<GenomicSample> rows = this.gm.get_visible_rows_raw();
        int rlen = rows.size();
        boolean use_progress_bar = true;
        boolean SUBSORT = true;
        boolean bl = cache_ok = this.last_rows != null && rows.equals(this.last_rows);
        if (!this.control_cluster.validate_distance_matrix_cache()) {
            cache_ok = false;
        }
        if (cache_ok) {
            System.err.println("distance matrix: cached!");
        } else {
            this.distance_matrix = new double[rlen][rlen];
            long matrix_start_time = System.currentTimeMillis();
            ProgressFrame pf = null;
            this.matrix_build_cancelled = false;
            if (use_progress_bar) {
                pf = new ProgressFrame("Working...", "Computing distance matrix...", rlen * rlen / 2, true);
                pf.addObserver(this);
            }
            int counter = 0;
            block2: for (i = 0; i < rlen; ++i) {
                GenomicSample x = rows.get(i);
                for (j = i + 1; j < rlen; ++j) {
                    double r;
                    if (use_progress_bar) {
                        if (this.matrix_build_cancelled) break block2;
                        pf.setValue(counter++);
                    }
                    try {
                        r = this.control_cluster.compute_single_distance(x.copynum_data, rows.get((int)j).copynum_data);
                    }
                    catch (ArithmeticException e) {
                        r = -100.0;
                    }
                    this.distance_matrix[i][j] = r;
                    this.distance_matrix[j][i] = r;
                }
            }
            long matrix_end_time = System.currentTimeMillis();
            if (use_progress_bar) {
                pf.setVisible(false);
                if (this.matrix_build_cancelled) {
                    return;
                }
            }
        }
        this.last_rows = rows;
        long cluster_start_time = System.currentTimeMillis();
        HashMap<String, Cluster> id2cluster = new HashMap<String, Cluster>();
        for (i = 0; i < rlen; ++i) {
            Integer row = i;
            String patient_id = rows.get((int)row.intValue()).patient_id;
            Cluster cluster = (Cluster)id2cluster.get(patient_id);
            if (cluster == null) {
                cluster = this.control_cluster.create_new_cluster();
                id2cluster.put(patient_id, cluster);
            }
            cluster.add(row);
        }
        HashSet<Cluster> clusters = new HashSet<Cluster>(id2cluster.values());
        this.control_cluster.precluster(clusters, rows);
        boolean ALLOW_R_CACHE = true;
        DoubleHashMap r_cache = new DoubleHashMap();
        while ((csize = clusters.size()) > 1) {
            ArrayList<Cluster> clist = new ArrayList<Cluster>(clusters);
            int best_i = 0;
            int best_j = 0;
            double best_distance = -100.0;
            for (i = 0; i < csize; ++i) {
                Cluster i_cluster = clist.get(i);
                for (j = i + 1; j < csize; ++j) {
                    double this_r;
                    Cluster j_cluster = clist.get(j);
                    if (ALLOW_R_CACHE) {
                        Double rc = (Double)r_cache.get(i_cluster, j_cluster);
                        if (rc != null) {
                            this_r = rc;
                        } else {
                            this_r = i_cluster.compare_cluster(j_cluster, this.distance_matrix, this.distance_method);
                            r_cache.put(i_cluster, j_cluster, new Double(this_r));
                        }
                    } else {
                        this_r = i_cluster.compare_cluster(j_cluster, this.distance_matrix, this.distance_method);
                    }
                    if (this_r == -100.0 || !(!this.control_cluster.are_higher_distance_values_closer() ? this_r < best_distance : this_r > best_distance) && best_distance != -100.0) continue;
                    best_i = i;
                    best_j = j;
                    best_distance = this_r;
                }
            }
            if (!(best_distance != -100.0 && this.control_cluster.are_higher_distance_values_closer() ? best_distance >= this.cluster_stop_threshold : best_distance <= this.cluster_stop_threshold)) break;
            Cluster best_x = clist.get(best_i);
            Cluster best_y = clist.get(best_j);
            best_x.addAll(best_y);
            best_x.set_internal_distance(best_distance);
            r_cache.removeAll(best_x);
            clusters.remove(best_y);
        }
        ArrayList<Cluster> cluster_list = new ArrayList<Cluster>(clusters);
        Collections.sort(cluster_list, cluster_list.get(0));
        Collections.reverse(cluster_list);
        ArrayList rows_new = new ArrayList();
        HashSet<Integer> dividers = new HashSet<Integer>();
        boolean cluster_i = false;
        this.cluster_list_final = new ArrayList();
        for (Cluster prc : cluster_list) {
            if (prc.size() <= 1) continue;
            ArrayList<GenomicSample> cr = new ArrayList<GenomicSample>();
            int[] arr$ = prc.get_ids();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Integer ri = arr$[i$];
                cr.add(rows.get(ri));
            }
            HashSet patient_ids = GenomicSample.get_patient_ids(cr);
            if (patient_ids.size() <= 1) continue;
            if (SUBSORT) {
                SampleSortTools sst = new SampleSortTools(cr);
                cr = sst.sort_by_cluster();
            }
            prc.set_sample_data(cr);
            this.cluster_list_final.add(prc);
            dividers.add(new Integer(rows_new.size()));
        }
        this.visible_in_clusters = this.gm.set_order_by_cluster(this.cluster_list_final, this.separate_null_leftovers);
        this.setChanged();
        this.notifyObservers();
        if (this.report_results) {
            new ClusterReporter(this, this.gm);
        }
    }

    public static void main(String[] argv) {
        try {
            GenomicMeasurement gm = new GenomicMeasurement("Gene_Mutation_top8_new.txt", false);
            ClusterTool ct = new ClusterTool(gm);
            ct.cluster(new PearsonRCluster(), true, true);
        }
        catch (Exception e) {
            System.err.println("ERROR:" + e);
        }
    }

    public ArrayList<Cluster> get_clusters() {
        return this.cluster_list_final;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.matrix_build_cancelled = true;
    }
}

