/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.ColorScheme;
import TCGA.GenomicMeasurement;
import TCGA.GenomicSample;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;

public class CopyNumberSummaryInfo2
extends Observable
implements Runnable,
Observer {
    private int change_threshold = 2;
    private GenomicMeasurement gm;
    private boolean built = false;
    public byte[] percent_showing_any = null;
    public byte[] percent_showing_increase = null;
    public byte[] percent_showing_decrease = null;
    public byte max_percent_showing_any = 0;
    public byte max_percent_showing_increase = 0;
    public byte max_percent_showing_decrease = 0;
    private ColorScheme cs;

    public CopyNumberSummaryInfo2(GenomicMeasurement gm) {
        this.gm = gm;
        ArrayList<ColorScheme> schemes = gm.get_color_manager().get_all_color_schemes();
        this.cs = schemes.get(0);
        this.cs.addObserver(this);
        gm.addObserver(this);
        this.run();
    }

    public void run() {
        this.set_threshold_from_gradients();
        this.build_all();
    }

    public int get_change_threshold() {
        return this.change_threshold;
    }

    public String get_bin_label(int index) {
        return this.gm.get_headers()[index];
    }

    public void set_change_threshold(int v) {
        this.change_threshold = v;
        this.build_all();
    }

    public void update(Observable o, Object arg) {
        if (o instanceof ColorScheme) {
            this.set_threshold_from_gradients();
        } else if (o instanceof GenomicMeasurement && this.gm.is_loaded()) {
            this.set_threshold_from_gradients();
        }
        if (this.gm.is_loaded()) {
            this.build_all();
        }
    }

    public boolean is_loaded() {
        return this.built;
    }

    private void build_all() {
        this.built = false;
        if (this.gm.is_loaded()) {
            this.generate_stats();
            this.built = true;
            this.setChanged();
            this.notifyObservers();
        }
    }

    private void set_threshold_from_gradients() {
        int[] gradients = this.cs.get_gradients();
        float FRACTION = 0.5f;
        int max_slider = gradients[gradients.length - 1];
        this.change_threshold = (int)((float)max_slider * FRACTION);
        if (this.change_threshold == 0) {
            this.change_threshold = 1;
        }
    }

    public byte[] get_percent_showing_any() {
        return this.percent_showing_any;
    }

    private void generate_stats() {
        int i;
        int sample_count = this.gm.get_row_count();
        int genome_bin_size = 0;
        int[] bin_increase = null;
        int[] bin_decrease = null;
        for (GenomicSample gs : this.gm.get_visible_rows()) {
            if (genome_bin_size == 0) {
                genome_bin_size = gs.copynum_data.length;
                bin_increase = new int[genome_bin_size];
                bin_decrease = new int[genome_bin_size];
            }
            for (i = 0; i < gs.copynum_data.length; ++i) {
                if (gs.copynum_data[i] == -99) continue;
                if (gs.copynum_data[i] >= this.change_threshold) {
                    int n = i;
                    bin_increase[n] = bin_increase[n] + 1;
                    continue;
                }
                if (gs.copynum_data[i] > -this.change_threshold) continue;
                int n = i;
                bin_decrease[n] = bin_decrease[n] + 1;
            }
        }
        this.percent_showing_any = new byte[genome_bin_size];
        this.percent_showing_increase = new byte[genome_bin_size];
        this.percent_showing_decrease = new byte[genome_bin_size];
        for (i = 0; i < genome_bin_size; ++i) {
            this.percent_showing_increase[i] = (byte)(bin_increase[i] * 100 / sample_count);
            this.percent_showing_decrease[i] = (byte)(bin_decrease[i] * 100 / sample_count);
            this.percent_showing_any[i] = (byte)((bin_increase[i] + bin_decrease[i]) * 100 / sample_count);
        }
        this.max_percent_showing_any = this.find_maximum(this.percent_showing_any);
        this.max_percent_showing_increase = this.find_maximum(this.percent_showing_increase);
        this.max_percent_showing_decrease = this.find_maximum(this.percent_showing_decrease);
    }

    private byte find_maximum(byte[] array) {
        byte result = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] <= result) continue;
            result = array[i];
        }
        return result;
    }

    public static void main(String[] argv) {
        try {
            String fn = "broad_snp6_genomicmeasurement.txt";
            GenomicMeasurement gm = new GenomicMeasurement(fn, false);
            ColorScheme colorScheme = new ColorScheme(Color.red, Color.blue);
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
        }
    }
}

