/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.ColorManager;
import TCGA.ColorScheme;
import TCGA.ErrorReporter;
import TCGA.GenomicMeasurement;
import TCGA.GenomicSample;
import TCGA.IndexColorModelMap;
import TCGA.Options;
import TCGA.SampleSubsets;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;

public class CopyNumberVariationImage
extends Observable
implements Runnable,
Observer {
    private BufferedImage offscreen = null;
    private boolean complete = false;
    private GenomicMeasurement gm;
    private Dimension raw_size;
    private IndexColorModelMap icmm;
    private static Color COLOR_NULL = Color.darkGray;

    public CopyNumberVariationImage(GenomicMeasurement gm) {
        this.gm = gm;
        for (ColorScheme cs : gm.get_color_manager().get_all_color_schemes()) {
            cs.addObserver(this);
        }
        this.setup();
    }

    private void setup() {
        this.refresh_image();
    }

    public void update(Observable o, Object arg) {
        if (this.gm.is_loaded()) {
            new Thread(this).start();
        }
    }

    public void run() {
        this.build_image();
    }

    private void build_image() {
        ArrayList<GenomicSample> gm_rows = this.gm.get_visible_rows();
        int sample_count = gm_rows.size();
        if (sample_count == 0) {
            if (this.offscreen != null) {
                Graphics g = this.offscreen.getGraphics();
                g.setColor(Color.black);
                g.fillRect(0, 0, this.offscreen.getWidth(), this.offscreen.getHeight());
            }
        } else {
            int width = gm_rows.get((int)0).copynum_data.length;
            this.raw_size = new Dimension(width, sample_count);
            if (this.offscreen == null) {
                try {
                    this.offscreen = new BufferedImage(width, this.gm.get_rows().size(), 13);
                    this.icmm = new IndexColorModelMap((IndexColorModel)this.offscreen.getColorModel());
                }
                catch (Throwable t) {
                    new ErrorReporter(t);
                }
            }
            long start_time = System.currentTimeMillis();
            if (Options.DISABLE_ACCELERATION) {
                try {
                    this.offscreen.setAccelerationPriority(0.0f);
                }
                catch (NoSuchMethodError e) {
                    System.err.println("can't set accleration priority on this JVM");
                }
            }
            Graphics g = this.offscreen.getGraphics();
            g.setColor(Color.black);
            g.fillRect(0, 0, this.offscreen.getWidth(), this.offscreen.getHeight());
            int[] rgb_array = new int[width];
            int rgb_null = COLOR_NULL.getRGB();
            byte null_i = (byte)this.icmm.find_closest_index(COLOR_NULL);
            WritableRaster raster = this.offscreen.getRaster();
            byte[] pixels = ((DataBufferByte)raster.getDataBuffer()).getData();
            int pi = 0;
            SampleSubsets ss = this.gm.get_sample_subsets();
            ColorManager cm = this.gm.get_color_manager();
            if (cm.is_multicolor_enabled()) {
                String[] subsets = ss.get_subsets();
                HashMap<String, ColorScheme> cs_map = cm.get_subset_colors();
                for (String subset : ss.get_subsets_arraylist()) {
                    pi = 0;
                    ColorScheme cs = cs_map.get(subset);
                    Color[] map_up = cs.get_up_color_map();
                    Color[] map_down = cs.get_down_color_map();
                    byte[] indexed_up = this.build_index_map(map_up, this.icmm);
                    byte[] indexed_down = this.build_index_map(map_down, this.icmm);
                    for (GenomicSample s : gm_rows) {
                        if (s.sample_id.indexOf(subset) >= 0) {
                            for (int x = 0; x < width; ++x) {
                                byte point = s.copynum_data[x];
                                byte ci = point >= 0 ? indexed_up[point] : (point == -99 ? null_i : indexed_down[(byte)Math.abs(point)]);
                                pixels[pi++] = ci;
                            }
                            continue;
                        }
                        pi += width;
                    }
                }
            } else {
                ColorScheme cs = cm.get_global_color_scheme();
                Color[] map_up = cs.get_up_color_map();
                Color[] map_down = cs.get_down_color_map();
                byte[] indexed_up = this.build_index_map(map_up, this.icmm);
                byte[] indexed_down = this.build_index_map(map_down, this.icmm);
                for (GenomicSample s : gm_rows) {
                    for (int x = 0; x < width; ++x) {
                        byte point = s.copynum_data[x];
                        byte ci = point >= 0 ? indexed_up[point] : (point == -99 ? null_i : indexed_down[(byte)Math.abs(point)]);
                        pixels[pi++] = ci;
                    }
                }
            }
        }
        this.complete = true;
        this.setChanged();
        this.notifyObservers();
    }

    public BufferedImage get_image() {
        return this.offscreen;
    }

    public int getWidth() {
        return this.offscreen.getWidth();
    }

    public int getHeight() {
        return this.offscreen.getHeight();
    }

    private void refresh_image() {
        this.update(null, null);
    }

    public boolean is_complete() {
        return this.complete;
    }

    public GenomicMeasurement get_genomicmeasurement() {
        return this.gm;
    }

    private int[] build_rgb_map(Color[] colors) {
        int[] rgb = new int[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            rgb[i] = colors[i].getRGB();
        }
        return rgb;
    }

    private byte[] build_index_map(Color[] colors, IndexColorModelMap icmm) {
        byte[] map = new byte[colors.length];
        for (int i = 0; i < colors.length; i = (int)((byte)(i + 1))) {
            map[i] = (byte)icmm.find_closest_index(colors[i]);
        }
        return map;
    }

    public Dimension get_raw_size() {
        return this.raw_size;
    }
}

