/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import java.text.ParseException;

public class DataScale {
    public static final String DATA_SCALE_TAG = "data_scale";
    int value;
    Float lower_bound;
    Float upper_bound;
    String lower_comparator;
    String upper_comparator;

    public DataScale(String raw) throws ParseException {
        String error = null;
        try {
            String[] f = raw.split(":");
            if (f.length == 2) {
                String[] comps;
                this.value = Integer.parseInt(f[0]);
                String[] levels = f[1].split("[<>=]+");
                if (levels.length >= 2 && levels.length <= 3) {
                    if (levels[1].equals("v")) {
                        this.lower_bound = Float.valueOf(Float.parseFloat(levels[0]));
                        if (levels.length == 3) {
                            this.upper_bound = Float.valueOf(Float.parseFloat(levels[2]));
                        }
                    } else {
                        error = "expected literal v in second list position";
                    }
                } else {
                    error = "array size error for bounds";
                }
                if ((comps = f[1].split("[\\-\\d\\.v]+")).length >= 2 && comps.length <= 3) {
                    if (comps[0].length() == 0) {
                        this.lower_comparator = comps[1].equals("<") ? ">" : (comps[1].equals("<=") ? ">=" : comps[1]);
                        if (comps.length == 3) {
                            this.upper_comparator = comps[2];
                        }
                    } else {
                        error = "first null expected";
                    }
                } else {
                    error = "array size error for comparators";
                }
            } else {
                error = "need 2 fields delimited by :";
            }
        }
        catch (Exception e) {
            error = "caught exception: " + e;
        }
        if (error != null) {
            throw new ParseException(error + " for " + raw, 0);
        }
    }
}

