/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.Cluster;
import TCGA.EuclideanClusterControl;
import TCGA.GenomicSample;
import TCGA.Statistics;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EuclideanCluster
extends Cluster
implements Comparator {
    private static Byte last_euclidean_limit = null;

    @Override
    public String get_method_name() {
        return "Euclidean distance";
    }

    @Override
    public boolean are_higher_distance_values_closer() {
        return false;
    }

    @Override
    public double compute_single_distance(byte[] sample1, byte[] sample2) throws ArithmeticException {
        return Statistics.euclidean_distance(sample1, sample2, true, (byte)-99, EuclideanClusterControl.EUCLIDEAN_LIMIT_DISTANCE);
    }

    @Override
    public Cluster create_new_cluster() {
        return new EuclideanCluster();
    }

    @Override
    public double get_default_cluster_stop_threshold() {
        return 0.0;
    }

    @Override
    public void precluster(HashSet<Cluster> clusters, ArrayList<GenomicSample> rows) {
    }

    @Override
    public boolean validate_distance_matrix_cache() {
        boolean ok = true;
        ok = last_euclidean_limit == null ? false : last_euclidean_limit.equals(EuclideanClusterControl.EUCLIDEAN_LIMIT_DISTANCE);
        last_euclidean_limit = EuclideanClusterControl.EUCLIDEAN_LIMIT_DISTANCE;
        return ok;
    }
}

