/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import Funk.LookAndFeeler;
import TCGA.Cluster;
import TCGA.ClusterTool;
import TCGA.EuclideanCluster;
import TCGA.GenomicMeasurement;
import TCGA.StatClusterControl;
import java.util.Observer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EuclideanClusterControl
extends StatClusterControl {
    private JTextField jt_threshold;
    private JTextField jt_limiter;
    private static String DEFAULT_DISTANCE = "1.25";
    private static String DEFAULT_LIMIT_DISTANCE = "2";
    public static byte EUCLIDEAN_LIMIT_DISTANCE = 0;

    public EuclideanClusterControl(GenomicMeasurement gm, Observer o) {
        super(gm, o);
    }

    public Cluster get_control_cluster() {
        return new EuclideanCluster();
    }

    public void final_panel_setup(JPanel jp) {
    }

    public int init_control_components(JPanel jp) {
        jp.add(new JLabel("Maximum Euclidean distance to cluster sequences:", 11));
        this.jt_threshold = new JTextField(6);
        jp.add(this.jt_threshold);
        this.jt_threshold.setText(DEFAULT_DISTANCE);
        jp.add(new JLabel("Limit distance on +/- axis to maximum of:", 11));
        this.jt_limiter = new JTextField(6);
        jp.add(this.jt_limiter);
        this.jt_limiter.setText(DEFAULT_LIMIT_DISTANCE);
        this.jt_limiter.setToolTipText("Limit positive and negative values for purposes distance calculation. e.g. copy-# distance between -2 and +2 is more interesting than between +2 and +6.");
        return 2;
    }

    public String cluster_setup(ClusterTool ct) {
        String tval = this.jt_threshold.getText();
        String tlimit = this.jt_limiter.getText();
        double max_e_dist = 0.0;
        String error = null;
        try {
            max_e_dist = Double.parseDouble(tval);
            if (max_e_dist < 0.0) {
                error = "Euclidean distance must be a positive number (fractional values are allowed).";
            } else {
                ct.set_cluster_stop_threshold(max_e_dist);
            }
        }
        catch (Exception ex) {
            error = "Euclidean distance must be a positive number.";
        }
        try {
            if (tlimit.length() == 0) {
                EUCLIDEAN_LIMIT_DISTANCE = 0;
            } else {
                EUCLIDEAN_LIMIT_DISTANCE = Byte.parseByte(tlimit);
                if (EUCLIDEAN_LIMIT_DISTANCE < 0) {
                    EUCLIDEAN_LIMIT_DISTANCE = 0;
                    error = "Limiter distance must be a positive integer.";
                }
            }
        }
        catch (Exception ex) {
            error = "Euclidean limiter distance must be a positive number.";
        }
        return error;
    }

    public static void main(String[] argv) {
        LookAndFeeler.set_native_lookandfeel();
    }
}

