/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import java.util.ArrayList;

public class FuzzyTCGAIDMatcher {
    int field_count_from;
    int field_count_to;
    boolean exact_match_mode;
    static boolean TRIM_TCGA_VIAL_ID = true;

    public FuzzyTCGAIDMatcher(int field_count_from, int field_count_to) {
        this.setup(field_count_from, field_count_to);
    }

    public FuzzyTCGAIDMatcher(String field_from, String field_to) {
        String[] ff = field_from.split("-");
        String[] ft = field_to.split("-");
        this.setup(ff.length, ft.length);
        if (field_from.indexOf("TCGA") != 0 || field_to.indexOf("TCGA") != 0) {
            this.exact_match_mode = true;
        }
    }

    private void setup(int field_count_from, int field_count_to) {
        this.field_count_from = field_count_from;
        this.field_count_to = field_count_to;
        this.exact_match_mode = field_count_from == field_count_to;
    }

    public boolean matches(String from_id, String to_id) {
        boolean result = false;
        result = this.exact_match_mode ? from_id.equals(to_id) : (this.field_count_from > this.field_count_to ? from_id.indexOf(this.trim_check(to_id, this.field_count_to)) == 0 : to_id.indexOf(this.trim_check(from_id, this.field_count_from)) == 0);
        return result;
    }

    public String trim_check(String id, int field_count) {
        String[] f;
        String result = id;
        if (TRIM_TCGA_VIAL_ID && field_count == 4 && (f = id.split("-"))[3].length() > 2) {
            result = id.substring(0, id.length() - 1);
        }
        return result;
    }

    public static void main(String[] argv) {
        ArrayList<String> from_ids = new ArrayList<String>();
        ArrayList<String> to_ids = new ArrayList<String>();
        from_ids.add("TCGA-29-1688-01A-01D");
        to_ids.add("TCGA-12-3456-78B");
        to_ids.add("TCGA-29-1688-01A");
        FuzzyTCGAIDMatcher m = new FuzzyTCGAIDMatcher((String)from_ids.get(0), (String)to_ids.get(0));
        for (String id_from : from_ids) {
            for (String id_to : to_ids) {
                if (!m.matches(id_from, id_to)) continue;
                System.err.println(id_from + " matches " + id_to);
            }
        }
    }
}

