/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.BinIndex;
import TCGA.CommentOptions;
import TCGA.GISTICPeak;
import TCGA.GenomicBin;
import TCGA.GenomicBinRange;
import TCGA.GenomicMeasurement;
import TCGA.GenomicSet;
import TCGA.SummaryPanelCNSI;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GISTIC {
    private GenomicMeasurement gm;
    private static boolean INVERT = true;
    private static boolean USE_LOG10_SCALE = true;
    private static int LOG_SCALE_LIMIT = (SummaryPanelCNSI.IMAGE_HEIGHT - 1) / 2;
    public static final String GISTIC_TAG = "gistic_data";
    public static final String TYPE_AMPLIFICATION = "+";
    public static final String TYPE_DELETION = "-";
    public static int VERBOSITY = 1;
    private static final int PEAK_MAPPING_BIN_FUDGE_COUNT = 5;
    private static ArrayList<String> DATA_TYPES;
    private HashMap<String, HashMap<String, GISTICPeak>> sym2peak;
    private HashMap<String, ArrayList<BigDecimal>> q_cooked;
    private HashMap<String, ArrayList<GISTICPeak>> peaks_ordered;
    private HashSet<String> all_subtypes;
    private ArrayList<String> all_subtypes_sorted;
    private BigDecimal max_value;
    private CommentOptions co;
    private ArrayList<GISTICPeak> peaks;

    public GISTIC(CommentOptions co) {
        this.co = co;
        this.sym2peak = new HashMap();
        this.q_cooked = new HashMap();
        this.peaks_ordered = new HashMap();
        this.all_subtypes = new HashSet();
        if (DATA_TYPES == null) {
            DATA_TYPES = new ArrayList();
            DATA_TYPES.add(TYPE_AMPLIFICATION);
            DATA_TYPES.add(TYPE_DELETION);
        }
        this.peaks = new ArrayList();
        this.max_value = new BigDecimal(0);
    }

    private String get_key(String sub_type, String data_type) {
        return sub_type + "_" + data_type;
    }

    private synchronized ArrayList<BigDecimal> get_arraylist(String key, HashMap<String, ArrayList<BigDecimal>> hash) {
        ArrayList<BigDecimal> result = hash.get(key);
        if (result == null) {
            result = new ArrayList();
            hash.put(key, result);
        }
        return result;
    }

    private synchronized ArrayList<GISTICPeak> get_arraylist2(String key, HashMap<String, ArrayList<GISTICPeak>> hash) {
        ArrayList<GISTICPeak> result = hash.get(key);
        if (result == null) {
            result = new ArrayList();
            hash.put(key, result);
        }
        return result;
    }

    private HashMap<String, GISTICPeak> get_sym2peak(String sub_type, String data_type) {
        String key = this.get_key(sub_type, data_type);
        HashMap<String, GISTICPeak> result = this.sym2peak.get(key);
        if (result == null) {
            result = new HashMap();
            this.sym2peak.put(key, result);
        }
        return result;
    }

    public void add(String s) {
        String[] f = s.split(",");
        GISTICPeak gp = new GISTICPeak(s);
        this.peaks.add(gp);
        this.all_subtypes.add(gp.sub_type);
        if (DATA_TYPES.contains(gp.data_type)) {
            HashMap<String, GISTICPeak> g2p = this.get_sym2peak(gp.sub_type, gp.data_type);
            for (String marker : gp.markers) {
                g2p.put(marker, gp);
            }
            if (USE_LOG10_SCALE) {
                if (INVERT) {
                    BigDecimal invert_log = new BigDecimal(gp.q.scale());
                    if (invert_log.compareTo(this.max_value) > 0) {
                        this.max_value = invert_log;
                    }
                } else {
                    System.err.println("ERROR: noninverted log10");
                }
            } else if (gp.q.compareTo(this.max_value) > 0) {
                this.max_value = gp.q;
            }
        } else {
            System.err.println("GISTIC parse error: unknown type " + f[0]);
        }
    }

    public void header_setup(GenomicMeasurement gm) {
        String[] headers = gm.get_headers();
        this.gm = gm;
        this.all_subtypes_sorted = new ArrayList<String>(this.all_subtypes);
        Collections.sort(this.all_subtypes_sorted);
        if (USE_LOG10_SCALE) {
            BigDecimal gate = new BigDecimal(LOG_SCALE_LIMIT);
            if (this.max_value.compareTo(gate) > 0) {
                this.max_value = gate;
            }
            if (!INVERT) {
                System.err.println("ERROR: uninverted log10 scale not implemented");
                System.exit(1);
            }
        }
        for (String key : this.sym2peak.keySet()) {
            HashMap<String, GISTICPeak> from = this.sym2peak.get(key);
            ArrayList<BigDecimal> to_cooked = this.get_arraylist(key, this.q_cooked);
            ArrayList<GISTICPeak> binned = this.get_arraylist2(key, this.peaks_ordered);
            for (int i = 0; i < headers.length; ++i) {
                GISTICPeak peak;
                if (headers[i].indexOf(",") != -1) {
                    String[] h = headers[i].split(",");
                    peak = null;
                    for (int j = 0; j < h.length && (peak = from.get(h[j])) == null; ++j) {
                    }
                } else {
                    peak = from.get(headers[i]);
                }
                if (peak == null) {
                    to_cooked.add(null);
                    binned.add(null);
                    continue;
                }
                peak.q_cooked = this.cook_value(peak.q);
                to_cooked.add(peak.q_cooked);
                binned.add(peak);
            }
        }
    }

    public void bin_infill(GenomicSet gs) {
        this.gene_fill_hack(gs);
    }

    private BigDecimal cook_value(BigDecimal v) {
        BigDecimal result = null;
        BigDecimal zero = new BigDecimal(0);
        if (INVERT && v != null) {
            if (USE_LOG10_SCALE) {
                int v2;
                if (v.equals(zero)) {
                    v2 = LOG_SCALE_LIMIT;
                } else {
                    v2 = v.scale();
                    if (v2 > LOG_SCALE_LIMIT) {
                        v2 = LOG_SCALE_LIMIT;
                    }
                }
                result = new BigDecimal(v2);
            } else {
                result = this.max_value.subtract(v);
            }
        } else if (USE_LOG10_SCALE && !INVERT) {
            System.err.println("ERROR: non-inverted log10 scale not implemented");
            System.exit(1);
        }
        return result;
    }

    public BigDecimal get_max_value() {
        return this.max_value;
    }

    public ArrayList<BigDecimal> get_display_data(String sub_type, String data_type) {
        return this.get_arraylist(this.get_key(sub_type, data_type), this.q_cooked);
    }

    public BigDecimal get_raw_value(String sub_type, String data_type, int x) {
        ArrayList<GISTICPeak> v = this.get_arraylist2(this.get_key(sub_type, data_type), this.peaks_ordered);
        BigDecimal result = null;
        if (x < v.size()) {
            GISTICPeak p = v.get(x);
            result = p == null ? null : p.q;
        }
        return result;
    }

    public GISTICPeak get_peak(String sub_type, String data_type, int x) {
        ArrayList<GISTICPeak> v = this.get_arraylist2(this.get_key(sub_type, data_type), this.peaks_ordered);
        GISTICPeak result = null;
        if (x < v.size()) {
            result = v.get(x);
        }
        return result;
    }

    public ArrayList<String> get_all_subtypes() {
        return this.all_subtypes_sorted;
    }

    public ArrayList<String> get_data_types() {
        return DATA_TYPES;
    }

    public String get_paint_priority() {
        return this.co.get("gistic_paint_priority");
    }

    private void gene_fill_hack(GenomicSet gs) {
        int i;
        String[] headers = this.gm.get_headers();
        BinIndex bi = new BinIndex(this.gm);
        int NULL = -1;
        ArrayList<GenomicBin> layout_bins = gs.get_bins();
        ArrayList<String> bin2chr = new ArrayList<String>();
        for (GenomicBin bin : layout_bins) {
            int needed = bin.end - bin2chr.size();
            for (i = 0; i < needed; ++i) {
                bin2chr.add("");
            }
            String chr = bin.bin_name;
            if (chr.indexOf("chr") != 0) {
                System.err.println("ERROR: bin " + chr + " not in UCSC chr format");
            }
            for (i = bin.start - 1; i < bin.end; ++i) {
                bin2chr.set(i, chr);
            }
        }
        for (GISTICPeak gp : this.peaks) {
            String peak_chr = gp.get_chromosome();
            GenomicBinRange gbr = gs.find_bins_for(gp.peak_pos);
            int mc = gp.markers.size();
            HashSet<Integer> bin_set = new HashSet<Integer>();
            for (String marker : gp.markers) {
                int distance;
                int ix;
                if (marker.indexOf("[") == 0 && marker.indexOf("]") == marker.length() - 1) {
                    marker = marker.substring(1, marker.length() - 1);
                }
                if ((ix = bi.find(marker)) == NULL) continue;
                String bin_chr = (String)bin2chr.get(ix);
                boolean ok = true;
                if (!bin_chr.equals(gp.peak_pos.chromosome)) {
                    ok = false;
                }
                if (gbr != null && !gbr.contains(ix) && (distance = gbr.get_distance(ix)) > 5) {
                    if (VERBOSITY >= 2) {
                        System.err.println("not mapping GISTIC hit, bin distance skew=" + distance);
                    }
                    ok = false;
                }
                if (!ok) continue;
                bin_set.add(ix);
            }
            ArrayList bins = new ArrayList(bin_set);
            Collections.sort(bins);
            int si = NULL;
            int ei = NULL;
            if (bins.size() > 0) {
                si = (Integer)bins.get(0);
                ei = (Integer)bins.get(bins.size() - 1);
            }
            if (si != NULL && ei != NULL) {
                String key = this.get_key(gp.sub_type, gp.data_type);
                ArrayList<BigDecimal> to_cooked = this.get_arraylist(key, this.q_cooked);
                ArrayList<GISTICPeak> binned = this.get_arraylist2(key, this.peaks_ordered);
                BigDecimal cooked_val = this.cook_value(gp.q);
                for (i = si; i <= ei; ++i) {
                    if (to_cooked.get(i) != null) continue;
                    to_cooked.set(i, cooked_val);
                    binned.set(i, gp);
                }
                continue;
            }
            if (VERBOSITY < 1) continue;
            System.err.println("ERROR: can't map GISTIC peak to bins for " + gp.markers);
        }
    }
}

