/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.GeneInfo;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneDatabase {
    private static GeneDatabase db = null;
    private ArrayList<GeneInfo> rows;
    private HashMap<String, GeneInfo> symbol2gene;

    private GeneDatabase() {
        this.parse();
    }

    private void parse() {
        ClassLoader cl = this.getClass().getClassLoader();
        String resource = "TCGA/gene_info.tab.gz";
        URL load_url = cl == null ? ClassLoader.getSystemResource(resource) : cl.getResource(resource);
        this.rows = new ArrayList();
        this.symbol2gene = new HashMap();
        if (load_url != null) {
            try {
                String line;
                URLConnection urlc = load_url.openConnection();
                InputStream is = urlc.getInputStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(new GZIPInputStream(is)));
                while ((line = br.readLine()) != null) {
                    String[] things = line.split("\t");
                    GeneInfo gi = new GeneInfo();
                    gi.gene_id = Integer.parseInt(things[0]);
                    gi.symbol = things[1];
                    gi.description = things[2];
                    this.symbol2gene.put(gi.symbol, gi);
                    this.rows.add(gi);
                }
            }
            catch (Exception e) {
                System.err.println("ERROR:" + e);
            }
        }
    }

    public GeneInfo get_gene_by_symbol(String s) {
        return this.symbol2gene.get(s);
    }

    public ArrayList<GeneInfo> get_rows() {
        return this.rows;
    }

    public static GeneDatabase get_gene_database() {
        if (db == null) {
            db = new GeneDatabase();
        }
        return db;
    }

    public static void main(String[] argv) {
        GeneDatabase db = GeneDatabase.get_gene_database();
        for (GeneInfo geneInfo : db.get_rows()) {
        }
    }
}

