/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import Funk.Str;
import TCGA.AnnotationFlatfile2;
import TCGA.Cluster;
import TCGA.ClusterTool;
import TCGA.ColorManager;
import TCGA.CommentOptions;
import TCGA.DividerManager;
import TCGA.DividerSet;
import TCGA.DoubleHashMap;
import TCGA.ErrorReporter;
import TCGA.FuzzyTCGAIDMatcher;
import TCGA.GISTIC;
import TCGA.GenomicBin;
import TCGA.GenomicSample;
import TCGA.GenomicSampleReformatter;
import TCGA.Hacktastic;
import TCGA.Heatmap6;
import TCGA.IdentifierMunger;
import TCGA.Options;
import TCGA.SampleSortTools;
import TCGA.SampleSubsets;
import TCGA.SampleSummaryInfo;
import TCGA.TrackInfo;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Observable;
import java.util.Vector;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenomicMeasurement
extends Observable
implements Runnable,
Cloneable {
    private String[] headers;
    private ArrayList<GenomicSample> rows;
    private ArrayList<GenomicSample> rows_raw;
    private ArrayList<GenomicSample> visible_rows;
    private ArrayList<GenomicSample> visible_rows_raw;
    private boolean is_loaded = false;
    private boolean is_binary = false;
    private boolean combined = false;
    private Exception parse_error = null;
    private int lines_read;
    private CommentOptions options;
    private ColorManager cm;
    private DividerManager dm;
    private boolean wants_patient_dividers = false;
    private InputStream ins;
    private SampleSubsets sample_subsets;
    private ArrayList<GenomicSample> unordered_samples;
    private SampleSummaryInfo ssi;
    private DoubleHashMap patient2sample_subset = null;
    public static final int MAX_DATAPOINT_VALUE = 98;
    private static final int REPORT_PROGRESS_LINES = 5;
    private static final int REPORT_PROGRESS_CELLS = 250000;
    private static final int BLOCK_ID_COMMENT = 1;
    private static final int BLOCK_ID_HEADERS = 2;
    private static final int BLOCK_ID_SAMPLE_NAME = 3;
    private static final int BLOCK_ID_SAMPLE_DATA_BYTE = 4;
    private static final int BLOCK_ID_SAMPLE_DATA_BYTE_RLE = 5;
    private static final String DELIMITER = "\t";

    public GenomicMeasurement(String fn) throws FileNotFoundException, IOException {
        this.detect_file_format(fn);
        this.ins = new FileInputStream(fn);
        if (fn.lastIndexOf(".gz") == fn.length() - 3) {
            this.ins = new GZIPInputStream(this.ins);
        }
        new Thread(this).start();
    }

    public GenomicMeasurement(String fn, boolean async) throws FileNotFoundException, IOException {
        this.detect_file_format(fn);
        this.ins = new FileInputStream(fn);
        if (fn.lastIndexOf(".gz") == fn.length() - 3) {
            this.ins = new GZIPInputStream(this.ins);
        }
        if (async) {
            new Thread(this).start();
        } else {
            this.run();
        }
    }

    public GenomicMeasurement(ArrayList<GenomicSample> rows, GenomicMeasurement gm_src) {
        this.rows = rows;
        this.headers = gm_src.get_headers();
        this.run();
    }

    public SampleSummaryInfo get_sample_summary_info() {
        return this.ssi;
    }

    private void detect_file_format(String fn) throws IOException {
        DataInputStream dis;
        byte b;
        this.ins = new FileInputStream(fn);
        if (fn.lastIndexOf(".gz") == fn.length() - 3) {
            this.ins = new GZIPInputStream(this.ins);
        }
        this.is_binary = (b = (dis = new DataInputStream(this.ins)).readByte()) != 35;
        this.ins.close();
    }

    public GenomicMeasurement(InputStream ins) throws IOException {
        this.ins = ins;
        new Thread(this).start();
    }

    public GenomicMeasurement(InputStream ins, boolean async, boolean is_binary) throws IOException {
        this.ins = ins;
        this.is_binary = is_binary;
        if (async) {
            new Thread(this).start();
        } else {
            this.run();
        }
    }

    public boolean is_loaded() {
        return this.is_loaded;
    }

    public int get_lines_read() {
        return this.lines_read;
    }

    public ArrayList<GenomicSample> get_rows() {
        return this.rows;
    }

    public ArrayList<GenomicSample> get_visible_rows() {
        return this.visible_rows;
    }

    public ArrayList<GenomicSample> get_visible_rows_raw() {
        return this.visible_rows_raw;
    }

    public ArrayList<GenomicSample> get_rows_raw() {
        return this.rows_raw;
    }

    public int set_order_by_patient_id(ArrayList<String> ordered, boolean separate_null_leftovers) {
        SampleSortTools sst = new SampleSortTools(this);
        HashMap<String, ArrayList<GenomicSample>> patient2sample = sst.get_patient2samples();
        ArrayList<GenomicSample> rows_new = new ArrayList<GenomicSample>();
        HashSet<String> saw_patients = new HashSet<String>();
        for (String patient_id : ordered) {
            if (saw_patients.contains(patient_id)) continue;
            rows_new.addAll((Collection)patient2sample.get(patient_id));
            saw_patients.add(patient_id);
        }
        int visible_given_rows = 0;
        for (GenomicSample gs : rows_new) {
            if (!gs.visible_in_display) continue;
            ++visible_given_rows;
        }
        this.unordered_samples = new ArrayList();
        if (separate_null_leftovers) {
            for (GenomicSample gs : this.rows) {
                if (saw_patients.contains(gs.patient_id)) continue;
                ArrayList<GenomicSample> samples = patient2sample.get(gs.patient_id);
                boolean all_null = true;
                for (GenomicSample gs2 : samples) {
                    if (!gs2.visible_in_display || gs2.all_null) continue;
                    all_null = false;
                    break;
                }
                if (all_null) continue;
                this.unordered_samples.addAll(samples);
                rows_new.addAll(samples);
                saw_patients.add(gs.patient_id);
            }
        }
        for (GenomicSample gs : this.rows) {
            if (saw_patients.contains(gs.patient_id)) continue;
            this.unordered_samples.addAll((Collection<GenomicSample>)patient2sample.get(gs.patient_id));
            rows_new.addAll((Collection<GenomicSample>)patient2sample.get(gs.patient_id));
            saw_patients.add(gs.patient_id);
        }
        this.set_rows(rows_new, true);
        return visible_given_rows;
    }

    public ArrayList<GenomicSample> get_unordered_samples() {
        return this.unordered_samples;
    }

    public int set_order_by_cluster(ArrayList<Cluster> cluster_list, boolean separate_null_leftovers) {
        ArrayList<String> patients = new ArrayList<String>();
        for (Cluster c : cluster_list) {
            ArrayList<GenomicSample> sd = c.get_sample_data();
            for (GenomicSample gs : sd) {
                patients.add(gs.patient_id);
            }
        }
        int visible_in_clusters = this.set_order_by_patient_id(patients, separate_null_leftovers);
        this.dm.set_cluster_list(cluster_list);
        return visible_in_clusters;
    }

    private void rebuild_visible_rows() {
        this.visible_rows = new ArrayList();
        for (GenomicSample gs : this.rows) {
            if (!gs.visible_in_display) continue;
            this.visible_rows.add(gs);
        }
        this.visible_rows_raw = new ArrayList();
        for (GenomicSample gs : this.rows_raw) {
            if (!gs.visible_in_display) continue;
            this.visible_rows_raw.add(gs);
        }
    }

    public int get_row_count() {
        return this.rows == null ? -1 : this.rows.size();
    }

    @Override
    public void run() {
        this.dm = new DividerManager(this);
        if (this.rows == null) {
            this.options = Options.COMMENT_OPTIONS = new CommentOptions();
            this.parse_stream();
            if (Options.STARTUP_RESTRICT_COLUMNS) {
                this.prefilter_data();
            }
        }
        this.rows_raw = new ArrayList<GenomicSample>(this.rows);
        this.rebuild_visible_rows();
        for (GenomicSample gs : this.rows) {
            gs.set_null_flags();
        }
        this.sample_subsets = new SampleSubsets(this);
        for (GenomicSample gs : this.rows) {
            String pid = new IdentifierMunger(gs.sample_id).get_patient();
            if (pid == null) {
                pid = this.sample_subsets.strip_id(gs.sample_id);
            }
            gs.patient_id = pid;
        }
        this.ssi = new SampleSummaryInfo(this);
        this.patient2sample_subset = new DoubleHashMap();
        if (!this.sample_subsets.isEmpty()) {
            for (GenomicSample gs : this.rows) {
                this.patient2sample_subset.put(gs.patient_id, gs.subset_id, gs);
            }
        }
        if (!this.sample_subsets.isEmpty()) {
            this.sample_subsets.set_visibility_flags();
            this.rebuild_visible_rows();
            this.rebuild_dividers();
        }
        byte neutral = 0;
        if (this.options.has_option("neutral")) {
            neutral = (byte)this.options.get_single_neutral_level();
            for (GenomicSample gs : this.rows) {
                int i = 0;
                while (i < gs.copynum_data.length) {
                    int n = i++;
                    gs.copynum_data[n] = (byte)(gs.copynum_data[n] - neutral);
                }
            }
        }
        this.cm = new ColorManager(this);
        String data_type = this.options.get("data_type");
        String title = this.options.get("title");
        if (data_type != null) {
            Options.DATA_TYPE = data_type;
        } else if (title != null && title != null) {
            if ((title = title.toLowerCase()).indexOf("gene expression") > -1) {
                Options.DATA_TYPE = "Gene expression";
            } else if (title.indexOf("methylation") > -1) {
                Options.DATA_TYPE = "Methylation";
            } else if (title.indexOf("copy number") > -1) {
                Options.DATA_TYPE = "Copy number";
            }
        }
        this.is_loaded = true;
        this.setChanged();
        this.notifyObservers();
    }

    private void parse_stream() {
        String line = null;
        long start_time = System.currentTimeMillis();
        BufferedReader br = this.is_binary ? null : new BufferedReader(new InputStreamReader(this.ins));
        try {
            String di;
            DividerSet dividers = this.dm.get_patient_dividers();
            Vector<Integer> out_of_range = new Vector<Integer>();
            int out_of_range_count = 0;
            this.lines_read = 0;
            int cells_read = 0;
            this.rows = new ArrayList();
            int progress_checkpoint = 250000;
            if (this.is_binary) {
                DataInputStream dis = new DataInputStream(this.ins);
                try {
                    int block_type;
                    GenomicSample gs = null;
                    while (true) {
                        block_type = dis.readInt();
                        int block_length = dis.readInt();
                        byte[] buf = new byte[block_length];
                        dis.readFully(buf);
                        if (block_type == 1) {
                            String s = new String(buf);
                            if (s.equals("#divider")) {
                                dividers.add(this.lines_read);
                                continue;
                            }
                            this.options.parse_line(s);
                            continue;
                        }
                        if (block_type == 2) {
                            this.parse_headers(new String(buf));
                            continue;
                        }
                        if (block_type == 3) {
                            gs = new GenomicSample();
                            gs.sample_id = new String(buf);
                            this.rows.add(gs);
                            ++this.lines_read;
                            continue;
                        }
                        if (block_type == 5) {
                            ByteArrayInputStream bis = new ByteArrayInputStream(buf);
                            DataInputStream dis2 = new DataInputStream(bis);
                            int si = 0;
                            gs.copynum_data = new byte[this.headers.length];
                            try {
                                block11: while (true) {
                                    byte b = dis2.readByte();
                                    int count = dis2.readInt();
                                    int i = 0;
                                    while (true) {
                                        if (i >= count) continue block11;
                                        gs.copynum_data[si++] = b;
                                        ++i;
                                    }
                                    break;
                                }
                            }
                            catch (EOFException eof) {
                                if (si == this.headers.length) continue;
                                throw new IOException("data vs. header length mismatch: " + si + " vs " + this.headers.length);
                            }
                        }
                        if (block_type != 4) break;
                        gs.copynum_data = buf;
                        for (int i = 0; i < gs.copynum_data.length; ++i) {
                            byte b = gs.copynum_data[i];
                            if (b == -99 || b >= -98 && b <= 98) continue;
                            if (out_of_range.size() < 5) {
                                out_of_range.add(Integer.valueOf(b));
                            }
                            ++out_of_range_count;
                            gs.copynum_data[i] = b < 0 ? -98 : 98;
                        }
                        if ((cells_read += gs.copynum_data.length) < progress_checkpoint) continue;
                        progress_checkpoint += 250000;
                        this.setChanged();
                        this.notifyObservers();
                    }
                    throw new Exception("parse error: unknown block type " + block_type);
                }
                catch (EOFException eof) {}
            } else {
                while (this.options.parse_line(line = br.readLine())) {
                }
                this.parse_headers(line);
                int v = 0;
                float vf = 0.0f;
                boolean float_mode = false;
                int expected_cols = this.headers.length + 1;
                boolean done = false;
                String encoding = this.options.get("sample_data_encoding");
                boolean rle_mode = false;
                if (encoding != null) {
                    if (encoding.equals("rle")) {
                        rle_mode = true;
                    } else {
                        this.parse_error = new Exception("unknown encoding " + encoding);
                        done = true;
                    }
                }
                while (!done && (line = br.readLine()) != null) {
                    int i;
                    String[] l = line.split(DELIMITER);
                    if (l[0].equals("#divider")) {
                        dividers.add(this.lines_read);
                        continue;
                    }
                    if (this.lines_read++ == 0) {
                        for (i = 1; i < l.length; ++i) {
                            if (l[i].indexOf(46) < 0) continue;
                            float_mode = true;
                            break;
                        }
                    }
                    if (l.length != expected_cols && !rle_mode) {
                        throw new IOException("line " + this.lines_read + " has " + l.length + " columns, we expected " + this.headers.length + " from header line");
                    }
                    GenomicSample gs = new GenomicSample();
                    gs.sample_id = new String(l[0]);
                    gs.copynum_data = new byte[expected_cols - 1];
                    if (rle_mode) {
                        int cdi = 0;
                        int rle_size = l.length / 2;
                        gs.rle_values = new byte[rle_size];
                        gs.rle_lengths = new int[rle_size];
                        int rle_i = 0;
                        for (i = 1; i < l.length; i += 2) {
                            v = Integer.parseInt(l[i]);
                            int count = Integer.parseInt(l[i + 1]);
                            if (v != -99) {
                                if (v < -98) {
                                    if (out_of_range.size() < 5) {
                                        out_of_range.add(new Integer(v));
                                    }
                                    ++out_of_range_count;
                                    v = -98;
                                } else if (v > 98) {
                                    if (out_of_range.size() < 5) {
                                        out_of_range.add(new Integer(v));
                                    }
                                    ++out_of_range_count;
                                    v = 98;
                                }
                            }
                            gs.rle_values[rle_i] = (byte)v;
                            gs.rle_lengths[rle_i] = count;
                            ++rle_i;
                            for (int j = 0; j < count; ++j) {
                                gs.copynum_data[cdi++] = (byte)v;
                            }
                        }
                    } else if (float_mode) {
                        for (i = 1; i < l.length; ++i) {
                            try {
                                vf = Float.parseFloat(l[i]);
                                if (vf != -99.0f) {
                                    if (vf < -98.0f) {
                                        if (out_of_range.size() < 5) {
                                            out_of_range.add(new Integer(v));
                                        }
                                        ++out_of_range_count;
                                        vf = -98.0f;
                                    } else if (vf > 98.0f) {
                                        if (out_of_range.size() < 5) {
                                            out_of_range.add(new Integer(v));
                                        }
                                        ++out_of_range_count;
                                        vf = 98.0f;
                                    }
                                }
                                gs.copynum_data[i - 1] = (byte)Math.round(vf);
                                continue;
                            }
                            catch (Exception e) {
                                if (Options.VERBOSE_ERRORS && !l[i].equals("NA")) {
                                    System.err.println("ERROR: datapoint parse of " + e);
                                }
                                gs.copynum_data[i - 1] = -99;
                            }
                        }
                    } else {
                        for (i = 1; i < l.length; ++i) {
                            try {
                                v = Integer.parseInt(l[i]);
                                if (v != -99) {
                                    if (v < -98) {
                                        if (out_of_range.size() < 5) {
                                            out_of_range.add(new Integer(v));
                                        }
                                        ++out_of_range_count;
                                        v = -98;
                                    } else if (v > 98) {
                                        if (out_of_range.size() < 5) {
                                            out_of_range.add(new Integer(v));
                                        }
                                        ++out_of_range_count;
                                        v = 98;
                                    }
                                }
                                gs.copynum_data[i - 1] = (byte)v;
                                continue;
                            }
                            catch (Exception e) {
                                if (Options.VERBOSE_ERRORS && !l[i].equals("NA")) {
                                    System.err.println("ERROR: datapoint parse of " + e);
                                }
                                gs.copynum_data[i - 1] = -99;
                            }
                        }
                    }
                    this.rows.add(gs);
                    if (this.lines_read % 5 != 0) continue;
                    this.setChanged();
                    this.notifyObservers();
                }
            }
            this.setChanged();
            this.notifyObservers();
            long end_time = System.currentTimeMillis();
            GISTIC gistic = this.options.get_gistic();
            if (gistic != null) {
                gistic.header_setup(this);
            }
            if (Options.VERBOSE_ERRORS && out_of_range_count > 0) {
                System.err.println(out_of_range_count + " values out of range: " + Str.join(out_of_range.elements()) + "...");
            }
            if ((di = this.options.get("divider_interval")) != null) {
                int divider_interval;
                for (int i = divider_interval = Integer.parseInt(di); i < this.rows.size(); i += divider_interval) {
                    dividers.add(i);
                }
            }
            this.wants_patient_dividers = !dividers.isEmpty();
        }
        catch (Exception e) {
            this.parse_error = e;
            System.err.println(e);
            new ErrorReporter(e);
        }
    }

    public static void main(String[] argv) {
        try {
            String fn = "broad_snp6_genomicmeasurement.txt";
            if (argv.length > 0) {
                fn = argv[0];
            }
            GenomicMeasurement gm = new GenomicMeasurement(fn, false);
            System.gc();
            System.err.println("done 1");
            System.gc();
            try {
                Thread.sleep(500000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            System.exit(1);
            AnnotationFlatfile2 af = new AnnotationFlatfile2("intgen.org_GBM.biotab.1.0.0.tab", false);
            for (GenomicSample gs : gm.get_rows()) {
                ArrayList annot = af.find_annotations(gs);
                System.err.println(gs.sample_id + " " + (annot == null ? "undef" : "ok"));
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
        }
    }

    public CommentOptions get_options() {
        return this.options;
    }

    public String[] get_headers() {
        return this.headers;
    }

    public void reorder_headers(ArrayList<Integer> new_order) {
        if (new_order.size() == this.headers.length) {
            String[] headers_new = new String[this.headers.length];
            int ti = 0;
            for (Integer si : new_order) {
                headers_new[ti++] = this.headers[si];
            }
            this.headers = headers_new;
        } else {
            System.err.println("ERROR: invalid length in header reorder attempt");
        }
    }

    public void set_rows(ArrayList<GenomicSample> rows, boolean reset_clusters) {
        this.rows = rows;
        this.rebuild_visible_rows();
        if (reset_clusters) {
            this.dm.clear_cluster_dividers();
        }
        this.rebuild_dividers();
        this.setChanged();
        this.notifyObservers();
    }

    public GenomicMeasurement clone() {
        GenomicMeasurement gm_new = null;
        try {
            gm_new = (GenomicMeasurement)super.clone();
            gm_new.clone_setup(this);
        }
        catch (Exception e) {
            System.err.println("clone error!:" + e);
        }
        return gm_new;
    }

    public void clone_setup(GenomicMeasurement gm_parent) {
        this.dm = new DividerManager(this);
        this.rebuild_dividers();
        this.sample_subsets = new SampleSubsets(this, gm_parent.get_sample_subsets());
    }

    public void generate_subset(ArrayList<Integer> bin_list) {
        int i;
        int count = bin_list.size();
        int[] bins = new int[count];
        for (i = 0; i < count; ++i) {
            bins[i] = bin_list.get(i);
        }
        String[] h2 = new String[count];
        for (i = 0; i < count; ++i) {
            h2[i] = this.headers[bins[i]];
        }
        ArrayList<GenomicSample> rows2 = new ArrayList<GenomicSample>();
        for (i = 0; i < this.rows.size(); ++i) {
            GenomicSample from = this.rows.get(i);
            GenomicSample to = from.clone();
            to.copynum_data = new byte[count];
            for (int j = 0; j < count; ++j) {
                to.copynum_data[j] = from.copynum_data[bins[j]];
            }
            to.set_null_flags();
            rows2.add(to);
        }
        System.err.println("fix me: rebuild SampleSummaryInfo");
        this.headers = h2;
        this.rows = rows2;
        this.rows_raw = new ArrayList<GenomicSample>(this.rows);
        this.rebuild_visible_rows();
        this.rebuild_dividers();
    }

    public void generate_subset(Rectangle sel) {
        String[] h2 = new String[sel.width];
        System.arraycopy(this.headers, sel.x, h2, 0, sel.width);
        ArrayList<GenomicSample> rows2 = new ArrayList<GenomicSample>();
        int rend = sel.y + sel.height;
        int rend2 = this.rows.size();
        for (int ri = sel.y; ri < rend && ri < rend2; ++ri) {
            GenomicSample from = this.rows.get(ri);
            GenomicSample to = from.clone();
            to.copynum_data = new byte[sel.width];
            System.arraycopy(from.copynum_data, sel.x, to.copynum_data, 0, sel.width);
            rows2.add(to);
        }
        this.headers = h2;
        this.rows = rows2;
        this.rows_raw = new ArrayList<GenomicSample>(this.rows);
        this.rebuild_visible_rows();
        this.rebuild_dividers();
    }

    public Rectangle generate_selection_start_end(int start_x, int end_x) {
        return this.generate_selection(start_x, end_x - start_x + 1);
    }

    public Rectangle generate_selection(int start_x, int width) {
        Rectangle r = new Rectangle();
        r.x = start_x;
        r.width = width;
        r.y = 0;
        r.height = this.get_row_count();
        return r;
    }

    public Rectangle generate_selection(GenomicBin gb) {
        return this.generate_selection(gb.start - 1, gb.end - gb.start + 1);
    }

    public Rectangle generate_selection(int bin) {
        return this.generate_selection(bin, 1);
    }

    public Rectangle generate_selection(ClusterTool ct) {
        Rectangle r = new Rectangle();
        r.x = 0;
        r.width = this.headers.length;
        r.y = 0;
        r.height = ct.get_visible_in_clusters();
        return r;
    }

    public Rectangle generate_selection(String patient_id) {
        Rectangle r = new Rectangle();
        r.x = 0;
        r.width = this.headers.length;
        r.y = 0;
        r.height = 0;
        int start = -1;
        int height = 0;
        int y = 0;
        for (GenomicSample gs : this.visible_rows) {
            if (gs.patient_id.equals(patient_id)) {
                ++height;
                if (start == -1) {
                    start = y;
                }
            } else if (start != -1) break;
            ++y;
        }
        r.y = start;
        r.height = height;
        return r;
    }

    private void rebuild_dividers() {
        if (this.wants_patient_dividers) {
            this.dm.rebuild_patient_dividers();
        }
        this.dm.rebuild_cluster_dividers();
    }

    private void parse_headers(String s) {
        String[] h = s.split(DELIMITER);
        this.headers = new String[h.length - 1];
        for (int i = 1; i < h.length; ++i) {
            this.headers[i - 1] = new String(h[i]);
        }
    }

    public float sort_by_bin(int index, String subset) {
        SampleSortTools sst = new SampleSortTools(this);
        if (subset != null) {
            sst.set_subset_filter(subset);
        }
        ArrayList<GenomicSample> sorted = sst.sort_by_bin(index);
        this.set_rows(sorted, true);
        return sst.get_average();
    }

    public int get_column_count() {
        if (this.is_loaded()) {
            return this.rows.get((int)0).copynum_data.length;
        }
        return -1;
    }

    public ArrayList<String> get_visible_sample_ids() {
        HashSet<String> ids = new HashSet<String>();
        for (GenomicSample gs : this.visible_rows) {
            ids.add(gs.patient_id);
        }
        ArrayList<String> unique_ids = new ArrayList<String>();
        unique_ids.addAll(ids);
        Collections.sort(unique_ids);
        return unique_ids;
    }

    public ArrayList<String> get_unique_patient_ids() {
        HashSet<String> ids = new HashSet<String>();
        ArrayList<String> unique_ids = new ArrayList<String>();
        for (GenomicSample gs : this.visible_rows) {
            if (!ids.contains(gs.patient_id)) {
                unique_ids.add(gs.patient_id);
            }
            ids.add(gs.patient_id);
        }
        return unique_ids;
    }

    public DividerManager get_divider_manager() {
        return this.dm;
    }

    public ColorManager get_color_manager() {
        return this.cm;
    }

    public SampleSubsets get_sample_subsets() {
        return this.sample_subsets;
    }

    public GenomicSample get_sample_for_patient_subset(String patient_id, String subset_id) {
        return (GenomicSample)this.patient2sample_subset.get(patient_id, subset_id);
    }

    public boolean is_genome_formatted() {
        String genome = this.get_options().get("genome");
        return genome != null && (genome.equalsIgnoreCase("on") || genome.equalsIgnoreCase("hg18") || genome.equalsIgnoreCase("hg19"));
    }

    public String get_genome_version() {
        String version = null;
        String genome = this.get_options().get("genome");
        if (genome != null) {
            if (genome.equalsIgnoreCase("on")) {
                version = "hg18";
            } else if (!genome.equalsIgnoreCase("off")) {
                if (genome.equalsIgnoreCase("hg18")) {
                    version = "hg18";
                } else if (genome.equalsIgnoreCase("hg19")) {
                    version = "hg19";
                }
            }
        }
        return version;
    }

    private void prefilter_data() {
        Options.NAVIGATION_DEFAULT_ZOOM = false;
        HashSet<Integer> bin_set = new HashSet<Integer>();
        HashSet<String> hdrs = new HashSet<String>();
        for (int i = 0; i < this.headers.length; ++i) {
            String[] h2 = this.headers[i].split(",");
            for (int j = 0; j < h2.length; ++j) {
                hdrs.add(h2[j]);
                if (!Options.RESTRICT_COLUMNS.contains(h2[j])) continue;
                bin_set.add(i);
            }
        }
        for (String col : Options.RESTRICT_COLUMNS) {
            if (hdrs.contains(col)) continue;
            System.err.println("ERROR: no column named " + col);
        }
        ArrayList<Integer> bin_list = new ArrayList<Integer>(bin_set);
        Collections.sort(bin_list);
        if (bin_list.size() > 0) {
            this.generate_subset(bin_list);
            GISTIC gistic = this.options.get_gistic();
            if (gistic != null) {
                GISTIC.VERBOSITY = 0;
                gistic.header_setup(this);
            }
            for (TrackInfo ti : this.options.get_tracks()) {
                ti.collapse_to(bin_list);
            }
        }
    }

    public void combine_datasets(ArrayList<GenomicMeasurement> gm_supplemental, Heatmap6 parent_ref) {
        if (!this.combined) {
            this.combined = true;
            if (gm_supplemental.size() == 0) {
                System.err.println("no data to combine");
                return;
            }
            new Hacktastic(parent_ref, gm_supplemental);
            while (true) {
                boolean all_loaded = true;
                for (GenomicMeasurement gms : gm_supplemental) {
                    if (gms.is_loaded()) continue;
                    all_loaded = false;
                }
                if (all_loaded) break;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {}
            }
            String parent_data_type = this.options.get("data_type");
            if (parent_data_type == null) {
                parent_data_type = "copy number";
            }
            ArrayList<String> all_data_types = new ArrayList<String>();
            all_data_types.add(parent_data_type);
            for (GenomicMeasurement gms : gm_supplemental) {
                String dtype = gms.get_options().get("data_type");
                System.err.println("supplemental type=" + dtype);
                all_data_types.add(dtype);
            }
            if (Options.COMBINE_DATASETS_ADD_ROWS_MODE) {
                String adt = Str.join(",", all_data_types);
                this.options.put("sample_subsets", adt);
                this.wants_patient_dividers = true;
            }
            ArrayList<GenomicSample> rows_combined = new ArrayList<GenomicSample>();
            HashSet<String> used_ids = new HashSet<String>();
            HashMap<GenomicMeasurement, GenomicSampleReformatter> reformatters = new HashMap<GenomicMeasurement, GenomicSampleReformatter>();
            for (GenomicMeasurement gms : gm_supplemental) {
                reformatters.put(gms, new GenomicSampleReformatter(this, gms));
            }
            if (Options.COMBINE_DATASETS_ADD_ROWS_MODE) {
                for (GenomicSample gs : this.rows_raw) {
                    String raw_id = gs.sample_id;
                    gs.sample_id = gs.sample_id + " " + parent_data_type;
                    rows_combined.add(gs);
                    for (GenomicMeasurement gms : gm_supplemental) {
                        String supp_type = gms.get_options().get("data_type");
                        ArrayList<GenomicSample> samples = gms.get_rows_raw();
                        FuzzyTCGAIDMatcher m = new FuzzyTCGAIDMatcher(raw_id, samples.get((int)0).sample_id);
                        for (GenomicSample sample : samples) {
                            if (!m.matches(raw_id, sample.sample_id)) continue;
                            rows_combined.add(this.copy_gs(sample, supp_type, (GenomicSampleReformatter)reformatters.get(gms)));
                            used_ids.add(gms + sample.sample_id);
                        }
                    }
                }
                for (GenomicMeasurement gms : gm_supplemental) {
                    String supp_type = gms.get_options().get("data_type");
                    for (GenomicSample sample : gms.get_rows_raw()) {
                        if (used_ids.contains(gms + sample.sample_id)) continue;
                        rows_combined.add(this.copy_gs(sample, supp_type, (GenomicSampleReformatter)reformatters.get(gms)));
                    }
                }
            } else {
                int i;
                int combined_column_count = this.headers.length * (gm_supplemental.size() + 1);
                String[] headers_new = new String[combined_column_count];
                for (i = 0; i < all_data_types.size(); ++i) {
                    String label = ((String)all_data_types.get(i)).toLowerCase();
                    if (label.equals("copy number")) {
                        label = Options.ABBREVIATION_COPY_NUMBER;
                    } else if (label.equals("gene expression")) {
                        label = Options.ABBREVIATION_GENE_EXPRESSION;
                    } else {
                        System.err.println("ERROR: unhandled label " + label);
                    }
                    all_data_types.set(i, label);
                }
                int j = 0;
                for (i = 0; i < this.headers.length; ++i) {
                    for (String dt : all_data_types) {
                        headers_new[j] = this.headers[i] + " " + dt;
                        ++j;
                    }
                }
                for (GenomicSample gs : this.rows_raw) {
                    rows_combined.add(gs);
                    GenomicSample[] gs_map = new GenomicSample[gm_supplemental.size()];
                    int mi = 0;
                    for (GenomicMeasurement gms : gm_supplemental) {
                        ArrayList<GenomicSample> samples = gms.get_rows_raw();
                        FuzzyTCGAIDMatcher m = new FuzzyTCGAIDMatcher(gs.sample_id, samples.get((int)0).sample_id);
                        ArrayList<GenomicSample> hits = new ArrayList<GenomicSample>();
                        for (GenomicSample sample : samples) {
                            if (!m.matches(gs.sample_id, sample.sample_id)) continue;
                            hits.add(sample);
                        }
                        int hit_count = hits.size();
                        GenomicSample match = null;
                        if (hit_count != 0) {
                            if (hit_count > 1) {
                                System.err.println("ERROR: multiple sample hits!!");
                            }
                            match = (GenomicSample)hits.get(0);
                            used_ids.add(gms + match.sample_id);
                        }
                        gs_map[mi++] = match;
                    }
                    byte[] combined_data = new byte[combined_column_count];
                    int ci = 0;
                    for (int hi = 0; hi < this.headers.length; ++hi) {
                        combined_data[ci++] = gs.copynum_data[hi];
                        mi = 0;
                        for (GenomicMeasurement gms : gm_supplemental) {
                            GenomicSample match;
                            if ((match = gs_map[mi++]) == null) {
                                combined_data[ci++] = -99;
                                continue;
                            }
                            GenomicSampleReformatter reformatter = (GenomicSampleReformatter)reformatters.get(gms);
                            combined_data[ci++] = reformatter.get_mapped(match, hi);
                        }
                    }
                    gs.copynum_data = combined_data;
                }
                HashMap<String, HashMap<GenomicMeasurement, GenomicSample>> orphans = new HashMap<String, HashMap<GenomicMeasurement, GenomicSample>>();
                for (GenomicMeasurement gms : gm_supplemental) {
                    for (GenomicSample sample : gms.get_rows_raw()) {
                        HashMap<GenomicMeasurement, GenomicSample> bucket;
                        if (used_ids.contains(gms + sample.sample_id)) continue;
                        String track_id = sample.patient_id;
                        if (track_id == null) {
                            track_id = sample.sample_id;
                        }
                        if ((bucket = (HashMap<GenomicMeasurement, GenomicSample>)orphans.get(track_id)) == null) {
                            bucket = new HashMap<GenomicMeasurement, GenomicSample>();
                            orphans.put(track_id, bucket);
                        }
                        bucket.put(gms, sample);
                    }
                }
                ArrayList sample_names = new ArrayList(orphans.keySet());
                Collections.sort(sample_names);
                for (String track_id : sample_names) {
                    HashMap bucket = (HashMap)orphans.get(track_id);
                    GenomicSample gs_new = new GenomicSample();
                    gs_new.sample_id = null;
                    gs_new.copynum_data = new byte[combined_column_count];
                    rows_combined.add(gs_new);
                    int ci = 0;
                    for (int hi = 0; hi < this.headers.length; ++hi) {
                        gs_new.copynum_data[ci++] = -99;
                        for (GenomicMeasurement gms : gm_supplemental) {
                            GenomicSample gs = (GenomicSample)bucket.get(gms);
                            if (gs == null) {
                                gs_new.copynum_data[ci++] = -99;
                                continue;
                            }
                            if (gs_new.sample_id == null) {
                                gs_new.sample_id = gs.sample_id;
                            }
                            GenomicSampleReformatter reformatter = (GenomicSampleReformatter)reformatters.get(gms);
                            gs_new.copynum_data[ci++] = reformatter.get_mapped(gs, hi);
                        }
                    }
                }
                this.headers = headers_new;
            }
            this.rows = new ArrayList(rows_combined);
            ArrayList<GenomicMeasurement> all_gms = new ArrayList<GenomicMeasurement>();
            all_gms.add(this);
            all_gms.addAll(gm_supplemental);
            String title = null;
            title = "combined " + Str.join("/", this.build_unique_list(all_gms, "project")) + ": ";
            ArrayList<String> pieces = new ArrayList<String>();
            for (GenomicMeasurement gm : all_gms) {
                ArrayList<String> stuff = new ArrayList<String>();
                stuff.add(gm.get_options().get("submitter"));
                stuff.add(gm.get_options().get("data_type"));
                stuff.add(gm.get_options().get("platform"));
                pieces.add(Str.join(" ", stuff));
            }
            title = title.concat(Str.join(" / ", pieces));
            this.get_options().put("title", title);
            this.run();
        }
    }

    private GenomicSample copy_gs(GenomicSample sample, String subset_type, GenomicSampleReformatter gsr) {
        GenomicSample gs_new = new GenomicSample();
        gs_new.sample_id = sample.sample_id + " " + subset_type;
        gs_new.copynum_data = gsr.remap(sample);
        return gs_new;
    }

    private ArrayList<String> build_unique_list(ArrayList<GenomicMeasurement> gms, String field) {
        HashSet<String> saw = new HashSet<String>();
        ArrayList<String> results = new ArrayList<String>();
        for (GenomicMeasurement gm : gms) {
            String value = gm.get_options().get(field);
            if (value == null || value.length() <= 0 || saw.contains(value)) continue;
            saw.add(value);
            results.add(value);
        }
        return results;
    }
}

