/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import java.util.ArrayList;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenomicSample
implements Cloneable {
    public static final int NULL_VALUE = -99;
    public String sample_id;
    public String patient_id;
    public String subset_id;
    public byte[] copynum_data;
    public boolean all_null = false;
    public boolean all_empty = false;
    public boolean visible_in_display = true;
    public boolean visible_to_sorting = true;
    public byte[] rle_values = null;
    public int[] rle_lengths = null;

    public void reorder_data(ArrayList<Integer> new_order) {
        if (this.rle_values != null) {
            System.err.println("FATAL ERROR: reorder attempt w/RLE data");
            System.exit(1);
        } else if (new_order.size() != this.copynum_data.length) {
            System.err.println("FATAL ERROR: invalid length in reorder");
            System.exit(1);
        }
        byte[] data_new = new byte[this.copynum_data.length];
        int ti = 0;
        for (Integer si : new_order) {
            data_new[ti++] = this.copynum_data[si];
        }
        this.copynum_data = data_new;
    }

    public GenomicSample clone() {
        GenomicSample gs_new = null;
        try {
            gs_new = (GenomicSample)super.clone();
        }
        catch (Exception e) {
            System.err.println("clone error!:" + e);
        }
        return gs_new;
    }

    public static HashSet get_patient_ids(ArrayList<GenomicSample> list) {
        HashSet<String> results = new HashSet<String>();
        for (GenomicSample gs : list) {
            results.add(gs.patient_id);
        }
        return results;
    }

    public static ArrayList<String> get_patient_id_list(ArrayList<GenomicSample> list) {
        ArrayList<String> results = new ArrayList<String>();
        HashSet<String> saw = new HashSet<String>();
        for (GenomicSample gs : list) {
            if (!saw.contains(gs.patient_id)) {
                results.add(gs.patient_id);
            }
            saw.add(gs.patient_id);
        }
        return results;
    }

    public void set_null_flags() {
        this.all_null = true;
        this.all_empty = true;
        for (int i = 0; i < this.copynum_data.length; ++i) {
            if (this.copynum_data[i] != -99) {
                this.all_null = false;
            }
            if (this.copynum_data[i] != 0) {
                this.all_empty = false;
            }
            if (!this.all_null && !this.all_empty) break;
        }
    }
}

