/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.GenomicMeasurement;
import TCGA.GenomicSample;
import java.util.HashMap;

public class GenomicSampleReformatter {
    private int[] header_map;
    HashMap<String, Integer> child_indices;

    public GenomicSampleReformatter(GenomicMeasurement parent, GenomicMeasurement child) {
        String[] child_headers = child.get_headers();
        this.child_indices = new HashMap();
        for (int i = 0; i < child_headers.length; ++i) {
            this.child_indices.put(child_headers[i], i);
        }
        String[] parent_headers = parent.get_headers();
        this.header_map = new int[parent_headers.length];
        for (int i = 0; i < parent_headers.length; ++i) {
            Integer index = this.child_indices.get(parent_headers[i]);
            this.header_map[i] = index == null ? -1 : index;
        }
    }

    public byte[] remap(GenomicSample child) {
        byte[] data = new byte[this.header_map.length];
        for (int i = 0; i < this.header_map.length; ++i) {
            data[i] = this.header_map[i] == -1 ? -99 : child.copynum_data[this.header_map[i]];
        }
        return data;
    }

    public byte get_mapped(GenomicSample child, int parent_header_index) {
        return this.header_map[parent_header_index] == -1 ? (byte)-99 : child.copynum_data[this.header_map[parent_header_index]];
    }
}

