/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.BinIndex;
import TCGA.GenomeScaler;
import TCGA.GenomicBin;
import TCGA.GenomicBinRange;
import TCGA.GenomicLocation;
import TCGA.GenomicMeasurement;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenomicSet
extends Observable
implements Observer {
    private ArrayList<GenomicBin> bins;
    private int bin_size = -1;
    private int bin_count = -1;
    private GenomicMeasurement gm;
    private boolean is_loaded = false;
    private boolean is_genomic = false;
    private boolean is_marker_bin = false;
    private static String CHR_PREFIX = "chr";
    public static final int STYLE_GENOMIC = 1;
    public static final int STYLE_MARKER_LABEL = 2;
    private int synthetic_bin_style = 0;

    public GenomicSet() {
    }

    public GenomicSet(String fn) throws IOException, FileNotFoundException {
        if (fn.lastIndexOf(".gz") == fn.length() - 3) {
            this.setup(new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(fn)))));
        } else {
            this.setup(new BufferedReader(new FileReader(fn)));
        }
    }

    public GenomicSet(InputStream ins) throws IOException {
        this.setup(new BufferedReader(new InputStreamReader(ins)));
    }

    public GenomicSet(GenomicMeasurement gm, int style, Observer o) {
        if (o != null) {
            this.addObserver(o);
        }
        this.gm = gm;
        this.synthetic_bin_style = style;
        this.is_loaded = false;
        this.bins = new ArrayList();
        gm.addObserver(this);
        this.update(null, null);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.gm.is_loaded() && this.bins.isEmpty()) {
            if (this.synthetic_bin_style == 1) {
                this.generate_genomic_bins(this.gm.get_column_count());
            } else if (this.synthetic_bin_style == 2) {
                this.generate_marker_bins();
            } else {
                System.err.println("ERROR: unknown bin style");
            }
        }
    }

    public boolean is_loaded() {
        return this.is_loaded;
    }

    private void setup(BufferedReader br) throws IOException {
        this.is_loaded = false;
        this.bins = new ArrayList();
        String delimiter = "\t";
        String header_line = br.readLine();
        String[] h = header_line.split(delimiter);
        if ((h[0].equals("Chromosome") || h[0].equals("BinName")) && h[1].equals("c1") && h[2].equals("c2")) {
            String line;
            boolean first = true;
            while ((line = br.readLine()) != null) {
                String[] f = line.split(delimiter);
                if (f.length == 3) {
                    GenomicBin gb = new GenomicBin(f[0], Integer.parseInt(f[1]), Integer.parseInt(f[2]));
                    this.bins.add(gb);
                    if (!first) continue;
                    this.is_genomic = gb.bin_name.indexOf("chr") == 0;
                    first = false;
                    continue;
                }
                throw new IOException("format error: line");
            }
        } else {
            throw new IOException("format error: header line " + header_line);
        }
        this.load_finished();
    }

    private void load_finished() {
        this.calculate_summary_info();
        this.is_loaded = true;
        this.setChanged();
        this.notifyObservers();
    }

    public ArrayList<GenomicBin> get_bins() {
        return this.bins;
    }

    private GenomeScaler get_genome_scaler() {
        if (this.gm == null) {
            System.err.println("hmm: no GenomicMeasurement ref, assuming hg18");
            return new GenomeScaler("hg18");
        }
        return new GenomeScaler(this.gm.get_genome_version());
    }

    public void generate_genomic_bins(int size) {
        BinIndex bi = new BinIndex(this.gm);
        boolean genome_to_scale = bi.is_multi_bin();
        GenomeScaler gs = this.get_genome_scaler();
        gs.set_dimension(new Dimension(size, 1));
        this.bins = new ArrayList();
        for (int chr = 1; chr <= 24; ++chr) {
            int start = gs.get_chr_position(chr, 2) + 1;
            int end = gs.get_chr_position(chr, 3);
            this.bins.add(new GenomicBin(CHR_PREFIX + this.get_chr_label(chr), start, end));
        }
        this.is_genomic = true;
        this.load_finished();
    }

    public String get_chr_label(int chr) {
        String label = Integer.toString(chr);
        if (chr == 23) {
            label = "X";
        }
        if (chr == 24) {
            label = "Y";
        }
        return label;
    }

    public GenomicLocation get_genomic_location_for_bin(int bin) {
        GenomicLocation result = new GenomicLocation();
        GenomeScaler gs = this.get_genome_scaler();
        for (GenomicBin gb : this.bins) {
            if (bin < gb.start || bin > gb.end) continue;
            result.chromosome = gb.bin_name;
            int bins_in_chr = gb.end - gb.start + 1;
            int bs = bin - gb.start;
            float start = (float)bs / (float)bins_in_chr;
            float end = (float)(bs + 1) / (float)bins_in_chr;
            int chr = this.chr2int(gb.bin_name);
            if (chr >= 1 && chr <= 24) {
                int clen = gs.get_chromosome_length_bp(chr);
                result.start = (int)((float)clen * start);
                result.end = (int)((float)clen * end);
                continue;
            }
            System.err.println("ERROR in chr format for " + gb.bin_name);
        }
        return result;
    }

    public static void main(String[] argv) {
        try {
            GenomicMeasurement gm = new GenomicMeasurement("Genome_CopyNumber_TCGA_BRCA_Level3.txt", false);
            GenomicSet gs = new GenomicSet(gm, 1, null);
            GenomicLocation gl = new GenomicLocation("chr10:200000-2000000");
            gs.find_bins_for(gl);
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
        }
    }

    private void calculate_summary_info() {
        this.bin_count = 0;
        for (GenomicBin gb : this.bins) {
            if (gb.end <= this.bin_count) continue;
            this.bin_count = gb.end;
        }
        if (this.is_genomic) {
            GenomeScaler gs = this.get_genome_scaler();
            long genome_length = gs.get_total_genome_length_bp();
            this.bin_size = (int)(genome_length / (long)this.bin_count);
        } else {
            this.bin_size = 1;
        }
    }

    public int get_bin_count() {
        return this.bin_count;
    }

    public int get_bin_for(int chrom, int position) {
        String l = CHR_PREFIX + this.get_chr_label(chrom);
        GenomicBin start_bin = null;
        int result = -1;
        for (GenomicBin gb : this.bins) {
            if (!gb.bin_name.equals(l)) continue;
            start_bin = gb;
            break;
        }
        if (start_bin == null) {
            System.err.println("ERROR translating bin coord for " + chrom + " pos " + position);
        } else {
            result = start_bin.start - 1 + position / this.bin_size;
        }
        return result;
    }

    public int chr2int(String chr) {
        int result;
        block4: {
            result = -1;
            if (chr.length() > 3 && chr.substring(0, 3).equals("chr")) {
                String rest = chr.substring(3);
                try {
                    result = Integer.parseInt(rest);
                }
                catch (NumberFormatException e) {
                    if (rest.equals("X")) {
                        result = 23;
                    }
                    if (!rest.equals("Y")) break block4;
                    result = 24;
                }
            }
        }
        return result;
    }

    public boolean is_marker_bin() {
        return this.is_marker_bin;
    }

    public void generate_marker_bins() {
        String[] headers = this.gm.get_headers();
        this.bins = new ArrayList();
        for (int i = 0; i < headers.length; ++i) {
            this.bins.add(new GenomicBin(headers[i], i + 1, i + 1));
        }
        this.is_genomic = false;
        this.is_marker_bin = true;
        this.load_finished();
    }

    private void dump_bins() {
        System.err.println("bin dump:");
        for (GenomicBin bin : this.bins) {
            System.err.println("  " + bin.bin_name + ": " + bin.start + "-" + bin.end);
        }
    }

    public Rectangle get_selection_for_chr_location(int chrom, int start, int end) {
        return this.gm.generate_selection_start_end(this.get_bin_for(chrom, start), this.get_bin_for(chrom, end));
    }

    public Rectangle get_selection_for_chr_location(String chrom, int start, int end) {
        int chr = this.chr2int(chrom);
        if (chr > 0) {
            return this.get_selection_for_chr_location(chr, start, end);
        }
        System.err.println("ERROR parsing chromosome: " + chrom);
        return null;
    }

    public void collapse_to(ArrayList<Integer> bin_list) {
        ArrayList<GenomicBin> new_bins = new ArrayList<GenomicBin>();
        int next_start = 1;
        for (GenomicBin bin : this.bins) {
            GenomicBin remapped = bin.map(bin_list, next_start);
            if (remapped == null) continue;
            new_bins.add(remapped);
            next_start = remapped.end + 1;
        }
        this.bins = new_bins;
        this.calculate_summary_info();
    }

    public GenomicBinRange find_bins_for(GenomicLocation gl) {
        GenomicBinRange result = null;
        GenomicBin hit_bin = null;
        for (GenomicBin bin : this.bins) {
            if (!bin.bin_name.equals(gl.chromosome)) continue;
            hit_bin = bin;
            break;
        }
        if (hit_bin == null) {
            System.err.println("ERROR: can't find chr in bin set: " + gl.chromosome);
        } else {
            result = new GenomicBinRange(hit_bin, gl, this.get_genome_scaler());
        }
        return result;
    }
}

