/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.util.HashMap;

public class IndexColorModelMap {
    private IndexColorModel icm;
    private byte[] r;
    private byte[] g;
    private byte[] b;
    private HashMap<Color, Integer> color2index;

    public IndexColorModelMap(IndexColorModel icm) {
        this.icm = icm;
        int size = icm.getMapSize();
        this.r = new byte[size];
        icm.getReds(this.r);
        this.g = new byte[size];
        icm.getGreens(this.g);
        this.b = new byte[size];
        icm.getBlues(this.b);
        this.color2index = new HashMap();
    }

    public static void main(String[] argv) {
        BufferedImage bi = new BufferedImage(800, 600, 13);
        IndexColorModelMap icmm = new IndexColorModelMap((IndexColorModel)bi.getColorModel());
        System.err.println("index=" + icmm.find_closest_index(Color.magenta));
        Color c = new Color(255, 0, 0);
        System.err.println("index=" + icmm.find_closest_index(c));
        Color c2 = new Color(255, 0, 0);
        System.err.println("index=" + icmm.find_closest_index(c2));
    }

    public int find_closest_index(Color c) {
        int best_i = 0;
        if (this.color2index.containsKey(c)) {
            best_i = this.color2index.get(c);
        } else {
            int size = this.icm.getMapSize();
            byte cr = (byte)c.getRed();
            byte cg = (byte)c.getGreen();
            byte cb = (byte)c.getBlue();
            int best_diff = 0;
            for (int i = 0; i < size; ++i) {
                int this_diff = Math.abs(cr - this.r[i]) + Math.abs(cg - this.g[i]) + Math.abs(cb - this.b[i]);
                if (i != 0 && this_diff >= best_diff) continue;
                best_i = i;
                best_diff = this_diff;
            }
            this.color2index.put(c, new Integer(best_i));
        }
        return best_i;
    }
}

