/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.HashMapArrayList;
import TCGA.Pathway;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathwayGenes
implements Runnable {
    private static HashMap<String, Pathway> pathways;
    private static ArrayList<String> pathway_names;
    private static HashMapArrayList gene2pathway;
    private static boolean load_started;
    private static boolean is_loaded;
    private static final boolean TRUNCATE_LONG_NAMES = false;
    private static final int TRUNCATE_LENGTH = 100;

    public PathwayGenes() {
        if (!load_started) {
            new Thread(this).start();
            load_started = true;
        }
    }

    @Override
    public void run() {
        ClassLoader cl = this.getClass().getClassLoader();
        String resource = "TCGA/pathway_genes.tab.gz";
        URL load_url = cl == null ? ClassLoader.getSystemResource(resource) : cl.getResource(resource);
        pathways = new HashMap();
        gene2pathway = new HashMapArrayList();
        if (load_url != null) {
            try {
                String line;
                URLConnection urlc = load_url.openConnection();
                InputStream is = urlc.getInputStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(new GZIPInputStream(is)));
                while ((line = br.readLine()) != null) {
                    String[] things = line.split("\t");
                    String name = things[1];
                    Pathway p = new Pathway(name);
                    p.pathway_id = Integer.parseInt(things[0]);
                    for (int i = 2; i < things.length; ++i) {
                        String gene = new String(things[i]);
                        p.add_gene(gene);
                        gene2pathway.put(gene, p);
                    }
                    pathways.put(p.name, p);
                }
                pathway_names = new ArrayList<String>(pathways.keySet());
                Collections.sort(pathway_names);
                is_loaded = true;
            }
            catch (Exception e) {
                System.err.println("ERROR:" + e);
            }
        }
    }

    public ArrayList<String> get_pathway_names() {
        return pathway_names;
    }

    public Pathway get_pathway(String name) {
        return pathways.get(name);
    }

    public static void main(String[] argv) {
        PathwayGenes pg = new PathwayGenes();
    }

    public boolean is_loaded() {
        return is_loaded;
    }

    public void sleep_until_ready() {
        while (!is_loaded) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    }

    public ArrayList<Pathway> find_pathways_for_gene(String gene) {
        return gene2pathway.get(gene);
    }

    static {
        load_started = false;
        is_loaded = false;
    }
}

