/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.Cluster;
import TCGA.ClusterTool;
import TCGA.GenomicMeasurement;
import TCGA.PearsonRCluster;
import TCGA.StatClusterControl;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.Hashtable;
import java.util.Observer;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;

public class PearsonClusterControl
extends StatClusterControl {
    private JSlider js_minimum_r;
    private JCheckBox jc_cluster_empty;

    public PearsonClusterControl(GenomicMeasurement gm, Observer o) {
        super(gm, o);
    }

    public Cluster get_control_cluster() {
        return new PearsonRCluster();
    }

    public int init_control_components(JPanel jp) {
        Cluster control_cluster = this.get_control_cluster();
        int rows_used = 0;
        this.js_minimum_r = new JSlider(0, 100, (int)(control_cluster.get_default_cluster_stop_threshold() * 100.0));
        this.js_minimum_r.setToolTipText("Higher values produce more tightly-correlated clusters, lower values produce more inclusive clusters.");
        int major_tick_spacing = 10;
        this.js_minimum_r.setMajorTickSpacing(major_tick_spacing);
        this.js_minimum_r.setMinorTickSpacing(1);
        this.js_minimum_r.setPaintTicks(true);
        this.js_minimum_r.setPaintLabels(true);
        this.js_minimum_r.setSnapToTicks(true);
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        for (int i = 0; i <= 100; i += major_tick_spacing) {
            double frac = (double)i / 100.0;
            labels.put(new Integer(i), new JLabel(new Double(frac).toString()));
        }
        this.js_minimum_r.setLabelTable(labels);
        jp.add(new JLabel("Minimum r to cluster sequences:", 11));
        jp.add(this.js_minimum_r);
        ++rows_used;
        jp.add(new JLabel("Cluster empty samples:", 11));
        this.jc_cluster_empty = new JCheckBox();
        jp.add(this.jc_cluster_empty);
        this.jc_cluster_empty.setSelected(false);
        this.jc_cluster_empty.setToolTipText("Pearson's r is uncomputable between empty rows; this option preclusters empty samples together.");
        return ++rows_used;
    }

    public void final_panel_setup(JPanel jp) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension pref = jp.getPreferredSize();
        pref.width = (int)((double)screen.width * 0.5);
        jp.setPreferredSize(pref);
    }

    public String cluster_setup(ClusterTool ct) {
        double min_r = (double)this.js_minimum_r.getValue() / 100.0;
        ct.set_cluster_stop_threshold(min_r);
        PearsonRCluster.CLUSTER_EMPTY_SEQUENCES = this.jc_cluster_empty.isSelected();
        return null;
    }
}

