/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.CommentOptions;
import TCGA.GenomicMeasurement;
import TCGA.GenomicSample;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JCheckBoxMenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleSubsets
implements ActionListener {
    private GenomicMeasurement gm;
    private String[] subsets;
    private HashSet<String> all_subsets;
    private ArrayList<String> visible_subsets;
    private HashMap<String, JCheckBoxMenuItem> checkboxes;

    public SampleSubsets(GenomicMeasurement gm) {
        this.gm = gm;
        this.setup();
    }

    public SampleSubsets(GenomicMeasurement gm, SampleSubsets parent) {
        this.gm = gm;
        this.setup();
        this.visible_subsets = new ArrayList<String>(parent.get_visible_subsets());
    }

    private void setup() {
        this.checkboxes = new HashMap();
        CommentOptions gm_options = this.gm.get_options();
        String subs = gm_options.get("sample_subsets");
        String visible_subs = gm_options.get("visible_sample_subsets");
        this.visible_subsets = new ArrayList();
        this.all_subsets = new HashSet();
        if (subs != null) {
            int i;
            this.subsets = subs.split(",");
            HashSet<String> vs = new HashSet<String>();
            if (visible_subs == null) {
                for (i = 0; i < this.subsets.length; ++i) {
                    vs.add(this.subsets[i]);
                }
            } else {
                String[] vsub = visible_subs.split(",");
                for (int i2 = 0; i2 < vsub.length; ++i2) {
                    vs.add(vsub[i2]);
                }
            }
            for (i = 0; i < this.subsets.length; ++i) {
                this.all_subsets.add(this.subsets[i]);
                if (!vs.contains(this.subsets[i])) continue;
                this.visible_subsets.add(this.subsets[i]);
            }
            block3: for (GenomicSample gs : this.gm.get_rows()) {
                for (int i3 = 0; i3 < this.subsets.length; ++i3) {
                    if (gs.sample_id.indexOf(this.subsets[i3]) < 0) continue;
                    gs.subset_id = this.subsets[i3];
                    continue block3;
                }
            }
        }
    }

    public ArrayList<JCheckBoxMenuItem> get_checkboxes() {
        ArrayList<JCheckBoxMenuItem> results = new ArrayList<JCheckBoxMenuItem>();
        results.addAll(this.checkboxes.values());
        return results;
    }

    public boolean isEmpty() {
        return this.gm.get_options().get("sample_subsets") == null;
    }

    public String[] get_subsets() {
        return this.subsets;
    }

    public ArrayList<String> get_subsets_arraylist() {
        ArrayList<String> results = new ArrayList<String>();
        if (this.subsets == null) {
            System.err.println("WTF: no subsets initialized");
        } else {
            for (int i = 0; i < this.subsets.length; ++i) {
                results.add(this.subsets[i]);
            }
        }
        return results;
    }

    public JCheckBoxMenuItem get_checkbox_menuitem(String s) {
        JCheckBoxMenuItem cb = this.checkboxes.get(s);
        if (cb == null) {
            cb = new JCheckBoxMenuItem(s, this.visible_subsets.contains(s));
            this.checkboxes.put(s, cb);
            cb.addActionListener(this);
        }
        return cb;
    }

    public ArrayList<String> get_visible_subsets() {
        return this.visible_subsets;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.visible_subsets = new ArrayList();
        for (int i = 0; i < this.subsets.length; ++i) {
            if (!this.checkboxes.get(this.subsets[i]).getState()) continue;
            this.visible_subsets.add(this.subsets[i]);
        }
        this.set_visibility_flags();
        this.gm.set_rows(this.gm.get_rows(), false);
    }

    public void set_visibility_flags() {
        ArrayList<GenomicSample> rows = this.gm.get_rows();
        for (GenomicSample gs : rows) {
            boolean visible = false;
            for (String subset : this.visible_subsets) {
                if (gs.sample_id.indexOf(subset) < 0) continue;
                visible = true;
                break;
            }
            gs.visible_in_display = visible;
        }
    }

    public String strip_id(String id) {
        String[] chunks = id.split("\\s+");
        int[] ok = new int[chunks.length];
        Arrays.fill(ok, 1);
        for (int i = 0; i < chunks.length; ++i) {
            if (!this.all_subsets.contains(chunks[i])) continue;
            ok[i] = 0;
        }
        String result = id;
        for (int i = 0; i < chunks.length; ++i) {
            if (ok[i] != 1) continue;
            result = chunks[i];
            break;
        }
        return result;
    }
}

