/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.Options;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class ScalePanel2
extends JPanel
implements AdjustmentListener,
ComponentListener {
    public static float DEFAULT_X_SCALE_LEVEL = 1.0f;
    public static float DEFAULT_Y_SCALE_LEVEL = 1.0f;
    private Dimension raw_size = null;
    private float x_scale_level = DEFAULT_X_SCALE_LEVEL;
    private float y_scale_level = DEFAULT_Y_SCALE_LEVEL;
    private JScrollBar jsb_h;
    private JScrollBar jsb_v;
    private boolean allow_scale = false;
    private float min_vertical_scale_level = 0.0f;
    private float max_vertical_scale_level = 0.0f;
    private float max_horizontal_scale_level = 0.0f;
    public static int ZOOM_DIRECTION_IN = 1;
    public static int ZOOM_DIRECTION_OUT = 2;
    public static int ZOOM_AXIS_HORIZONTAL = 3;
    public static int ZOOM_AXIS_VERTICAL = 4;
    public static int ZOOM_AXIS_BOTH = 5;
    public static int ZOOM_AXIS_NONE = 6;

    public ScalePanel2() {
        this.raw_size = new Dimension(0, 0);
        this.setup();
    }

    public ScalePanel2(Dimension raw_size, JScrollBar jsb_h, JScrollBar jsb_v) {
        this.raw_size = raw_size;
        this.jsb_h = jsb_h;
        this.jsb_v = jsb_v;
        this.setup();
    }

    private void setup() {
        if (this.jsb_h != null) {
            this.set_horizontal_scrollbar(this.jsb_h);
        }
        if (this.jsb_v != null) {
            this.set_vertical_scrollbar(this.jsb_v);
        }
        this.addComponentListener(this);
    }

    public void set_min_vertical_scale_level(float l) {
        this.min_vertical_scale_level = l;
    }

    public void set_max_vertical_scale_level(float l) {
        this.max_vertical_scale_level = l;
    }

    public void set_max_horizontal_scale_level(float l) {
        this.max_horizontal_scale_level = l;
    }

    public float get_max_horizontal_scale_level() {
        return this.max_horizontal_scale_level;
    }

    public float get_max_vertical_scale_level() {
        return this.max_vertical_scale_level;
    }

    public void set_allow_scale(boolean scale) {
        this.allow_scale = scale;
    }

    public boolean get_allow_scale() {
        return this.allow_scale;
    }

    public JScrollBar get_horizontal_scrollbar() {
        return this.jsb_h;
    }

    public JScrollBar get_vertical_scrollbar() {
        return this.jsb_v;
    }

    public void zoom_to_selection(int start_x, int width) {
        Dimension d = this.getSize();
        float x_scale = (float)d.width / (float)width;
        this.set_horizontal_scale_level(x_scale);
        this.jsb_h.setValue((int)((float)start_x * x_scale));
        this.repaint();
    }

    public void zoom_to_vertical_selection(int start_y, int height) {
        Dimension d = this.getSize();
        float y_scale = (float)d.height / (float)height;
        this.set_vertical_scale_level(y_scale);
        this.jsb_v.setValue((int)((float)start_y * y_scale));
        this.repaint();
    }

    public Dimension get_scaled_size(Dimension d) {
        return new Dimension((int)((float)d.width * this.x_scale_level), (int)((float)d.height * this.y_scale_level));
    }

    public Dimension get_scaled_size() {
        return this.get_scaled_size(this.raw_size);
    }

    public void set_raw_size(Dimension d) {
        this.raw_size = d;
    }

    public int get_raw_height() {
        return this.raw_size.height;
    }

    public int get_raw_width() {
        return this.raw_size.width;
    }

    public int get_scaled_width() {
        return this.get_scaled_size().width;
    }

    public int get_scaled_height() {
        return this.get_scaled_size().height;
    }

    public void set_horizontal_scrollbar(JScrollBar jsb_h) {
        this.jsb_h = jsb_h;
        jsb_h.addAdjustmentListener(this);
        this.set_extents_horizontal();
    }

    public void set_vertical_scrollbar(JScrollBar jsb_v) {
        this.jsb_v = jsb_v;
        jsb_v.addAdjustmentListener(this);
        this.set_extents_vertical();
    }

    public void set_extents_horizontal() {
        if (this.jsb_h == null) {
            System.err.println("ERROR: null h scrollbar!");
        } else {
            BoundedRangeModel brm = this.jsb_h.getModel();
            brm.setMinimum(0);
            brm.setMaximum(this.get_scaled_width());
            Dimension d = this.getSize();
            int extent = d.width;
            int block = (int)((double)d.width * 0.9);
            int unit = d.width / 10;
            if (unit < 1) {
                unit = 1;
            }
            brm.setExtent(extent);
            this.jsb_h.setUnitIncrement(unit);
            this.jsb_h.setBlockIncrement(block);
        }
    }

    public void set_extents_vertical() {
        BoundedRangeModel brm = this.jsb_v.getModel();
        brm.setMinimum(0);
        brm.setMaximum(this.get_scaled_height() + (int)((double)this.y_scale_level * 0.49));
        Dimension d = this.getSize();
        int extent = d.height;
        int block = (int)((double)d.height * 0.9);
        int unit = d.height / 10;
        if ((float)unit < this.y_scale_level) {
            unit = (int)this.y_scale_level;
        }
        brm.setExtent(extent);
        this.jsb_v.setUnitIncrement(unit);
        this.jsb_v.setBlockIncrement(block);
    }

    public float get_horizontal_scale_level() {
        return this.x_scale_level;
    }

    public float get_vertical_scale_level() {
        return this.y_scale_level;
    }

    public void set_horizontal_scale_level(float f) {
        this.x_scale_level = f;
        this.set_extents_horizontal();
        this.repaint();
    }

    public void set_vertical_scale_level(float f) {
        this.y_scale_level = f;
        this.set_extents_vertical();
        this.repaint();
    }

    public void set_scale_levels(float h, float v) {
        System.err.println("set scale levels:" + h);
        this.x_scale_level = h;
        this.y_scale_level = v;
        this.set_extents_horizontal();
        this.set_extents_vertical();
    }

    public void zoom_in() {
        this.zoom_in(Options.ZOOM_FACTOR);
    }

    public void center_on_x(int x) {
        int start = (int)((float)x * this.x_scale_level) - this.jsb_h.getModel().getExtent() / 2;
        if (start < 0) {
            start = 0;
        }
        this.jsb_h.setValue(start);
    }

    public void center_on_region(Rectangle r) {
        int end = r.x + r.width;
        this.center_on_x(r.x + r.width / 2);
    }

    public void zoom(int direction, int axis, float factor, Point mp) {
        if (axis != ZOOM_AXIS_NONE) {
            if (axis == ZOOM_AXIS_BOTH) {
                this.zoom(direction, ZOOM_AXIS_HORIZONTAL, factor, mp);
                this.zoom(direction, ZOOM_AXIS_VERTICAL, factor, mp);
            } else {
                float before;
                if (direction == ZOOM_DIRECTION_OUT) {
                    factor = 1.0f / factor;
                }
                JScrollBar jsb = null;
                if (axis == ZOOM_AXIS_HORIZONTAL) {
                    before = this.x_scale_level;
                    this.x_scale_level *= factor;
                    float min = this.get_max_zoom_out_level();
                    if (this.x_scale_level < min) {
                        this.x_scale_level = min;
                    }
                    if (this.max_horizontal_scale_level > 0.0f && this.x_scale_level > this.max_horizontal_scale_level) {
                        this.x_scale_level = this.max_horizontal_scale_level;
                        if (this.x_scale_level < before) {
                            this.x_scale_level = before;
                        }
                        factor = this.x_scale_level / before;
                    }
                    jsb = this.jsb_h;
                } else if (axis == ZOOM_AXIS_VERTICAL) {
                    before = this.y_scale_level;
                    this.y_scale_level *= factor;
                    if (this.min_vertical_scale_level > 0.0f && this.y_scale_level < this.min_vertical_scale_level) {
                        this.y_scale_level = this.min_vertical_scale_level;
                        factor = this.min_vertical_scale_level / before;
                    }
                    if (this.max_vertical_scale_level > 0.0f && this.y_scale_level > this.max_vertical_scale_level) {
                        this.y_scale_level = this.max_vertical_scale_level;
                        factor = this.max_vertical_scale_level / before;
                    }
                    jsb = this.jsb_v;
                } else {
                    System.err.println("zoom(): format ERROR!");
                }
                float extent = jsb.getModel().getExtent();
                float half_extent = (float)jsb.getModel().getExtent() / 2.0f;
                float center = (float)jsb.getValue() + half_extent;
                if (Options.MOUSE_ZOOM_INFLUENCED_BY_CURSOR && mp != null && (!Options.MOUSE_ZOOM_INFLUENCED_BY_CURSOR_IN_ONLY || direction == ZOOM_DIRECTION_IN)) {
                    float frac = axis == ZOOM_AXIS_HORIZONTAL ? (float)mp.x / (float)this.getSize().width : (float)mp.y / (float)this.getSize().height;
                    float mouse_val = (float)jsb.getValue() + extent * frac;
                    center = (mouse_val + center * (float)Options.MOUSE_ZOOM_INFLUENCE_DILUTION) / (float)(Options.MOUSE_ZOOM_INFLUENCE_DILUTION + 1);
                }
                float scaled_center = center * factor;
                int start_new = (int)(scaled_center - half_extent);
                if (axis == ZOOM_AXIS_HORIZONTAL) {
                    this.set_extents_horizontal();
                } else {
                    this.set_extents_vertical();
                }
                jsb.setValue(start_new);
                this.repaint();
            }
        }
    }

    public void zoom_in(float factor) {
        this.x_scale_level *= factor;
        int half_extent = this.jsb_h.getModel().getExtent() / 2;
        int center = this.jsb_h.getValue() + half_extent;
        int scaled_center = (int)((float)center * factor);
        int x_start_new = scaled_center - half_extent;
        this.set_extents_horizontal();
        this.jsb_h.setValue(x_start_new);
        this.repaint();
    }

    public void zoom_out() {
        this.zoom_out(Options.ZOOM_FACTOR);
    }

    public void zoom_out(float factor) {
        this.x_scale_level /= factor;
        float max = this.get_max_zoom_out_level();
        if (this.x_scale_level < max) {
            this.x_scale_level = max;
            System.err.println("gated:" + this.x_scale_level);
        }
        int half_extent = this.jsb_h.getModel().getExtent() / 2;
        int center = this.jsb_h.getValue() + half_extent;
        int scaled_center = (int)((float)center / factor);
        int start_new = scaled_center - half_extent;
        this.set_extents_horizontal();
        this.set_extents_vertical();
        this.jsb_h.setValue(start_new);
        this.repaint();
    }

    private float get_max_zoom_out_level() {
        int extent = this.jsb_h.getModel().getExtent();
        Dimension d = this.getSize();
        if (extent < d.width) {
            extent = d.width;
        }
        return (float)extent / (float)this.raw_size.width;
    }

    public void zoom_out_max_y() {
        this.zoom_reset_y();
        this.y_scale_level = this.get_max_zoom_out_level_y();
        this.set_extents_vertical();
        this.repaint();
    }

    public void zoom_reset_y() {
        if (this.y_scale_level != 1.0f) {
            float factor = 1.0f / this.y_scale_level;
            this.zoom_in_y(factor);
        }
    }

    public void zoom_in_y(float factor) {
        this.y_scale_level *= factor;
        int half_extent = this.jsb_v.getModel().getExtent() / 2;
        int center = this.jsb_v.getValue() + half_extent;
        int scaled_center = (int)((float)center * factor);
        int y_start_new = scaled_center - half_extent;
        this.set_extents_vertical();
        this.jsb_v.setValue(y_start_new);
        this.repaint();
    }

    private float get_max_zoom_out_level_y() {
        int extent = this.jsb_v.getModel().getExtent();
        Dimension d = this.getSize();
        if (extent < d.height) {
            extent = d.height;
        }
        return (float)extent / (float)this.raw_size.height;
    }

    public void zoom_out_max() {
        this.zoom_reset();
        this.x_scale_level = this.get_max_zoom_out_level();
        this.set_extents_horizontal();
        this.repaint();
    }

    public void zoom_reset() {
        if (this.x_scale_level != 1.0f) {
            float factor = 1.0f / this.x_scale_level;
            this.zoom_in(factor);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.repaint();
    }

    public int get_unscaled_x_start() {
        int v = this.jsb_h == null ? 0 : this.jsb_h.getValue();
        return (int)((float)v / this.x_scale_level);
    }

    public int get_unscaled_x_end() {
        int v = 0;
        if (this.jsb_h != null) {
            v = this.jsb_h.getValue() + this.jsb_h.getModel().getExtent();
        }
        return (int)((float)v / this.x_scale_level);
    }

    public int get_unscaled_y_start() {
        int v = this.jsb_v == null ? 0 : this.jsb_v.getValue();
        return (int)((float)v / this.y_scale_level);
    }

    public int get_unscaled_y_end() {
        int v = 0;
        if (this.jsb_v != null) {
            v = this.jsb_v.getValue() + this.jsb_v.getModel().getExtent();
        }
        return (int)((float)v / this.y_scale_level);
    }

    public Point get_unscaled_point(Point p) {
        int x = this.jsb_h == null ? p.x : this.get_unscaled_x_start() + (int)((float)p.x / this.x_scale_level);
        int y = this.jsb_v == null ? p.y : this.get_unscaled_y_start() + (int)((float)p.y / this.y_scale_level);
        return new Point(x, y);
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        if (this.jsb_h != null) {
            this.set_extents_horizontal();
        }
        if (this.jsb_v != null) {
            this.set_extents_vertical();
        }
        if (Options.LOCK_ZOOM_OUT) {
            this.zoom_out_max();
        }
    }

    public void componentShown(ComponentEvent e) {
        this.set_extents_horizontal();
        this.set_extents_vertical();
    }
}

