/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleHTMLGrid {
    private HashMap<String, HashMap<String, String>> data;
    private ArrayList<String> column_labels;
    private ArrayList<String> row_labels;
    private HashSet<String> row_label_set;
    private HashSet<String> column_label_set;
    private boolean use_th_for_headers = true;
    private boolean use_underline_for_headers = false;
    private int border = 0;
    private boolean show_column_labels = true;
    private String row_label_align = null;

    public SimpleHTMLGrid() {
        this.column_labels = new ArrayList();
        this.row_labels = new ArrayList();
        this.row_label_set = new HashSet();
        this.column_label_set = new HashSet();
        this.setup();
    }

    public SimpleHTMLGrid(ArrayList<String> column_labels, ArrayList<String> row_labels) {
        this.column_labels = column_labels;
        this.row_labels = row_labels;
        this.row_label_set = new HashSet<String>(row_labels);
        this.setup();
    }

    private void setup() {
        this.data = new HashMap();
    }

    public void set_row_label_align(String v) {
        this.row_label_align = v;
    }

    public void set_th_headers(boolean v) {
        this.use_th_for_headers = v;
    }

    public void set_underline_headers(boolean v) {
        this.use_underline_for_headers = v;
    }

    public void set_cell_value(String column, String row, String value) {
        this.add_column(column);
        this.add_row(row);
        HashMap<String, String> hr = this.data.get(column);
        if (hr == null) {
            hr = new HashMap();
            this.data.put(column, hr);
        }
        hr.put(row, value);
    }

    public void set_cell_value(String column, String row, int value) {
        this.set_cell_value(column, row, Integer.toString(value));
    }

    public String get_cell_value(String column, String row) {
        String result;
        HashMap<String, String> hr = this.data.get(column);
        String string = result = hr == null ? "" : hr.get(row);
        if (result == null) {
            result = "";
        }
        return result;
    }

    public void add_column(String s) {
        if (!this.column_label_set.contains(s)) {
            this.column_labels.add(s);
            this.column_label_set.add(s);
        }
    }

    public void add_row(String s) {
        if (!this.row_label_set.contains(s)) {
            this.row_labels.add(s);
            this.row_label_set.add(s);
        }
    }

    private void open_tag(String tag, StringBuffer sb) {
        sb.append("<" + tag + ">");
    }

    private void close_tag(String tag, StringBuffer sb) {
        sb.append("</" + tag + ">");
    }

    public void set_border(int b) {
        this.border = b;
    }

    public void set_show_column_labels(boolean v) {
        this.show_column_labels = v;
    }

    public StringBuffer generate_html() {
        StringBuffer sb = new StringBuffer();
        if (this.border > 0) {
            sb.append("<table border=" + this.border + ">\n");
        } else {
            sb.append("<table>\n");
        }
        if (this.show_column_labels) {
            sb.append("<tr>\n");
            String header_tag = this.use_th_for_headers ? "th" : "td";
            this.open_tag(header_tag, sb);
            this.close_tag(header_tag, sb);
            for (String col : this.column_labels) {
                this.open_tag(header_tag, sb);
                if (this.use_underline_for_headers) {
                    this.open_tag("u", sb);
                }
                sb.append(col);
                if (this.use_underline_for_headers) {
                    this.close_tag("u", sb);
                }
                this.close_tag(header_tag, sb);
                sb.append("\n");
            }
            sb.append("</tr>\n");
        }
        for (String row : this.row_labels) {
            sb.append("<tr>\n");
            sb.append("  <td");
            if (this.row_label_align != null) {
                sb.append(" align=" + this.row_label_align);
            }
            sb.append(">" + row + ":\n");
            for (String col : this.column_labels) {
                sb.append("  <td>" + this.get_cell_value(col, row) + "</td>\n");
            }
            sb.append("</tr>\n");
        }
        sb.append("</table>");
        return sb;
    }

    public static void main(String[] argv) {
        SimpleHTMLGrid ht = new SimpleHTMLGrid();
        ht.set_th_headers(false);
        ht.set_underline_headers(true);
        ht.add_column("broad");
        ht.add_column("focal");
        ht.add_row("q-value");
        ht.add_row("z-score");
        ht.set_cell_value("broad", "q-value", "1.23");
        ht.set_cell_value("focal", "z-score", "xxx");
        StringBuffer sb = ht.generate_html();
        System.err.println(sb);
    }
}

