/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.Options;
import TCGA.ScalePanel2;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.math.BigDecimal;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SummaryPanel
extends ScalePanel2 {
    public ArrayList<Point> digest_array(byte[] array, byte max_value, float scale_by, boolean normalize) {
        float scale_factor;
        float x;
        int i;
        ArrayList<Point> results = new ArrayList<Point>();
        int start_x = this.get_unscaled_x_start();
        int end_x = this.get_unscaled_x_end();
        if (end_x >= array.length) {
            end_x = array.length - 1;
        }
        float x_scale = this.get_horizontal_scale_level();
        int bin_size = (int)(1.0f / x_scale);
        Point p = null;
        if (bin_size >= 2) {
            i = start_x;
            x = 0.0f;
            while (i <= end_x) {
                byte y = 0;
                for (int j = i; j < i + bin_size && j <= end_x; ++j) {
                    if (array[j] <= y) continue;
                    y = array[j];
                }
                p = new Point((int)x, y);
                if (p.y > 0) {
                    results.add(p);
                }
                i += bin_size;
                x += x_scale * (float)bin_size;
            }
        } else {
            i = start_x;
            x = 0.0f;
            while (i <= end_x) {
                p = new Point((int)x, array[i]);
                if (p.y > 0) {
                    results.add(p);
                }
                ++i;
                x += x_scale;
            }
        }
        if (scale_by != 1.0f) {
            for (Point p3 : results) {
                p3.y = (int)((float)p3.y * scale_by);
            }
        }
        if (normalize && (scale_factor = 100.0f / (float)max_value) != 1.0f) {
            for (Point p2 : results) {
                p2.y = (int)((float)p2.y * scale_factor);
            }
        }
        return results;
    }

    public ArrayList<Point> digest_arraylist(ArrayList<BigDecimal> array, float scale_by) {
        ArrayList<Point> results = new ArrayList<Point>();
        int start_x = this.get_unscaled_x_start();
        int end_x = this.get_unscaled_x_end();
        if (end_x >= array.size()) {
            end_x = array.size() - 1;
        }
        float x_scale = this.get_horizontal_scale_level();
        int bin_size = (int)(1.0f / x_scale);
        int MIN_VALUE = 2;
        if (bin_size >= 2) {
            int i = start_x;
            float x = 0.0f;
            while (i <= end_x) {
                float y = 0.0f;
                boolean present = false;
                for (int j = i; j < i + bin_size && j <= end_x; ++j) {
                    Number n = array.get(j);
                    if (n == null) continue;
                    present = true;
                    float f = n.floatValue();
                    if (!(f > y)) continue;
                    y = f;
                }
                y *= scale_by;
                if (present) {
                    results.add(new Point((int)x, this.floor(y, MIN_VALUE)));
                }
                i += bin_size;
                x += x_scale * (float)bin_size;
            }
        } else {
            int i = start_x;
            float x = 0.0f;
            while (i <= end_x) {
                Number n = array.get(i);
                if (n != null) {
                    float y = n.floatValue() * scale_by;
                    results.add(new Point((int)x, this.floor(y, MIN_VALUE)));
                }
                ++i;
                x += x_scale;
            }
        }
        return results;
    }

    private int floor(float f, int floor) {
        int v = (int)f;
        if (v < floor) {
            v = floor;
        }
        return v;
    }

    public void render_array(Graphics g, ArrayList<Point> points, int base_y, boolean add) {
        float x_scale = this.get_horizontal_scale_level();
        if (x_scale > 1.0f) {
            int last_end = 0;
            int last_start = 0;
            for (Point p : points) {
                int x2 = p.x + (int)(x_scale + 1.0f);
                int width = x2 - p.x;
                int x = p.x;
                if (x < last_end) {
                    int diff = last_end - x;
                    x += diff;
                    width -= diff;
                }
                if (x == last_start && x2 == last_end) {
                    System.err.println("ERROR 2");
                }
                g.fillRect(x, add ? base_y : base_y - p.y, width, p.y);
                last_start = x;
                last_end = x2;
            }
        } else {
            Point last_point = null;
            for (Point p : points) {
                if (p.equals(last_point)) continue;
                g.drawLine(p.x, base_y, p.x, base_y + (add ? p.y : -p.y));
                last_point = p;
            }
        }
    }

    public Font get_label_font() {
        return new Font("Times", 0, Options.SUMMARY_PANEL_FONT_HEIGHT);
    }

    public void draw_label(Graphics g, String text, Color c_background, Color c_text, int y) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Font f = this.get_label_font();
        FontMetrics fm = this.getFontMetrics(f);
        TextLayout textTl = new TextLayout(text, f, g2.getFontRenderContext());
        Shape shape = textTl.getOutline(new AffineTransform());
        Rectangle r = shape.getBounds();
        AffineTransform at = new AffineTransform();
        at.translate(Options.SUMMARY_PANEL_INDENT_PIXELS, y);
        AffineTransform at_orig = g2.getTransform();
        g2.transform(at);
        Composite c_old = g2.getComposite();
        AlphaComposite ac = AlphaComposite.getInstance(3, 0.8f);
        g2.setComposite(ac);
        g2.setPaint(c_background);
        g2.setStroke(new BasicStroke(3.5f));
        g2.draw(shape);
        g2.fill(shape);
        g2.setComposite(c_old);
        g2.setPaint(c_text);
        g2.setStroke(new BasicStroke(1.0f));
        g2.fill(shape);
        g2.setTransform(at_orig);
    }
}

