/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import Funk.Gr;
import TCGA.CopyNumberSummaryInfo2;
import TCGA.Options;
import TCGA.SummaryPanel;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JOptionPane;

public class SummaryPanelCNSI
extends SummaryPanel
implements Observer,
MouseListener {
    public static int IMAGE_HEIGHT = 75;
    protected CopyNumberSummaryInfo2 cnsi;

    public SummaryPanelCNSI(CopyNumberSummaryInfo2 cnsi, int raw_width) {
        this.cnsi = cnsi;
        cnsi.addObserver(this);
        this.set_raw_size(new Dimension(raw_width, IMAGE_HEIGHT));
        this.addMouseListener(this);
    }

    public void update(Observable o, Object arg) {
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        Integer result;
        Object[] values = new Integer[Options.MAX_GRADIENTS];
        Object current = null;
        int threshold = this.cnsi.get_change_threshold();
        for (int i = 0; i < Options.MAX_GRADIENTS; ++i) {
            int v = i + 1;
            values[i] = new Integer(v);
            if (v != threshold) continue;
            current = values[i];
        }
        if (current == null) {
            current = values[0];
        }
        if ((result = (Integer)JOptionPane.showInputDialog(Gr.getFrame(this), "Threshold value for inclusion in graph:", "Set graph threshold", 3, null, values, current)) != null) {
            this.cnsi.set_change_threshold(result);
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public String generate_tooltip(Point mp, String label, byte[] array) {
        Point up = this.get_unscaled_point(mp);
        String result = up.x >= 0 && up.x < array.length ? array[up.x] + "% of samples" + " at " + this.cnsi.get_bin_label(up.x) + " show " + label + " using threshold " + this.cnsi.get_change_threshold() + " (click to change)" : "Frequency of " + label;
        return result;
    }
}

