/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import Funk.Str;
import TCGA.ColorScheme;
import TCGA.ColorSchemeModel;
import TCGA.CopyNumberSummaryInfo2;
import TCGA.GISTIC;
import TCGA.GISTICPeak;
import TCGA.HelpLauncher;
import TCGA.Options;
import TCGA.PopupListener;
import TCGA.SimpleHTMLGrid;
import TCGA.SummaryPanelCNSI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JPopupMenu;

public class SummaryPanelIncreaseDecrease
extends SummaryPanelCNSI {
    private static Color COLOR_INCREASE = Color.red;
    private static Color COLOR_DECREASE = Color.blue;
    private static Color COLOR_BACKGROUND = Color.white;
    private static Color COLOR_TEXT = Color.black;
    private static Color COLOR_BASELINE = Color.black;
    private static final String LABEL_HELP = "Help: increase/decrease panel";
    private static final int MAX_GISTIC_MARKERS_PER_LINE = 5;
    private static final int MAX_GISTIC_MARKERS_TO_DISPLAY = 50;
    private int middle = 0;
    private ColorScheme color_scheme;
    private GISTIC gistic;
    private boolean gistic_mode;

    public SummaryPanelIncreaseDecrease(CopyNumberSummaryInfo2 cnsi, int raw_width, ColorScheme color_scheme, GISTIC gistic) {
        super(cnsi, raw_width);
        this.gistic = gistic;
        this.gistic_mode = gistic != null;
        this.setToolTipText("+/-");
        this.color_scheme = color_scheme;
        JPopupMenu jpm = new JPopupMenu();
        jpm.add(HelpLauncher.generate_jmenuitem(LABEL_HELP, "panel_increase_decrease"));
        new PopupListener(this, jpm);
    }

    protected void paintComponent(Graphics g) {
        float scale_by;
        Dimension d = this.getSize();
        int half = this.middle = d.height / 2;
        int start_x = this.get_unscaled_x_start();
        int end_x = this.get_unscaled_x_end();
        float x_scale = this.get_horizontal_scale_level();
        g.setColor(COLOR_BACKGROUND);
        g.fillRect(0, 0, d.width, d.height);
        ColorSchemeModel csm = this.color_scheme.get_colorscheme_model();
        if (this.gistic_mode) {
            ArrayList<String> subs;
            scale_by = (float)(half - 1) / this.gistic.get_max_value().floatValue();
            String priority_subtype = this.gistic.get_paint_priority();
            if (priority_subtype == null) {
                subs = this.gistic.get_all_subtypes();
            } else {
                subs = new ArrayList();
                for (String subtype : this.gistic.get_all_subtypes()) {
                    if (subtype.equals(priority_subtype)) continue;
                    subs.add(subtype);
                }
                subs.add(priority_subtype);
            }
            int iteration = 0;
            for (String subtype : this.gistic.get_all_subtypes()) {
                for (String data_type : this.gistic.get_data_types()) {
                    boolean add;
                    Color c;
                    ArrayList<Point> points = this.digest_arraylist(this.gistic.get_display_data(subtype, data_type), scale_by);
                    if (data_type.equals("+")) {
                        c = csm.up_color;
                        add = false;
                    } else {
                        c = csm.down_color;
                        add = true;
                    }
                    if (priority_subtype == null) {
                        if (iteration > 0) {
                            c = this.fade_color(c);
                        }
                    } else if (!subtype.equals(priority_subtype)) {
                        c = this.fade_color(c);
                    }
                    g.setColor(c);
                    this.render_array(g, points, this.middle, add);
                }
                ++iteration;
                if (priority_subtype != null) continue;
                g.setXORMode(COLOR_BACKGROUND);
            }
            g.setPaintMode();
        } else {
            scale_by = (float)half / 100.0f;
            ArrayList<Point> points = this.digest_array(this.cnsi.percent_showing_increase, this.cnsi.max_percent_showing_increase, scale_by, Options.NORMALIZE_SUMMARY_PANEL_PEAKS);
            g.setColor(csm.up_color);
            this.render_array(g, points, this.middle, false);
            points = this.digest_array(this.cnsi.percent_showing_decrease, this.cnsi.max_percent_showing_decrease, scale_by, Options.NORMALIZE_SUMMARY_PANEL_PEAKS);
            g.setColor(csm.down_color);
            this.render_array(g, points, this.middle, true);
        }
        g.setColor(COLOR_BASELINE);
        g.drawLine(0, this.middle, d.width, this.middle);
        FontMetrics fm = this.getFontMetrics(this.get_label_font());
        String upper_label = Options.COMMENT_OPTIONS.get("high_label");
        String lower_label = Options.COMMENT_OPTIONS.get("low_label");
        if (upper_label != null) {
            this.draw_label(g, upper_label, COLOR_BACKGROUND, COLOR_TEXT, fm.getAscent());
        }
        if (lower_label != null) {
            this.draw_label(g, lower_label, COLOR_BACKGROUND, COLOR_TEXT, d.height - fm.getDescent());
        }
    }

    public String getToolTipText(MouseEvent e) {
        byte[] array;
        Point mp = e.getPoint();
        String label = "";
        String upper_label = Options.COMMENT_OPTIONS.get("high_label");
        String lower_label = Options.COMMENT_OPTIONS.get("low_label");
        String result = "";
        if (mp.y <= this.middle) {
            label = upper_label == null ? "increase" : upper_label;
            array = this.cnsi.percent_showing_increase;
        } else {
            label = lower_label == null ? "decrease" : lower_label;
            array = this.cnsi.percent_showing_decrease;
        }
        label = label.toLowerCase();
        if (this.gistic_mode) {
            Point up = this.get_unscaled_point(mp);
            String amp_or_del = mp.y <= this.middle ? "amplification" : "deletion";
            SimpleHTMLGrid st = new SimpleHTMLGrid();
            st.set_th_headers(false);
            st.set_underline_headers(true);
            st.add_row("q-value");
            st.add_row("location");
            boolean has_data = false;
            if (up.x >= 0) {
                GISTICPeak focal_peak = this.gistic.get_peak("focal", mp.y <= this.middle ? "+" : "-", up.x);
                String bin_label = focal_peak == null ? this.cnsi.get_bin_label(up.x) : Str.join(",", focal_peak.markers);
                ArrayList<String> subtypes = new ArrayList<String>();
                subtypes.add("focal");
                subtypes.add("broad");
                for (String subtype : subtypes) {
                    GISTICPeak peak = this.gistic.get_peak(subtype, mp.y <= this.middle ? "+" : "-", up.x);
                    if (peak == null) continue;
                    has_data = true;
                    String column_label = subtype + " peak";
                    st.set_cell_value(column_label, "location", peak.peak_pos.toString());
                    if (subtype.equals("focal")) {
                        st.add_row("markers");
                        StringBuffer sb = new StringBuffer();
                        int count = 0;
                        int size = peak.markers.size();
                        for (String marker : peak.markers) {
                            if (count >= 50) {
                                sb.append("...");
                                break;
                            }
                            if (count > 0) {
                                if (count < size) {
                                    sb.append(", ");
                                }
                                if (count % 5 == 0) {
                                    sb.append("<br>\n");
                                }
                            }
                            sb.append(marker);
                            ++count;
                        }
                        st.set_cell_value(column_label, "markers", sb.toString());
                    }
                    st.add_column(column_label);
                    st.set_cell_value(column_label, "q-value", peak.q.toString());
                    if (peak.z_score == null) continue;
                    st.add_row("z-score");
                    st.set_cell_value(column_label, "z-score", peak.z_score.toString());
                }
            }
            result = has_data ? "<html><center><b>GISTIC " + amp_or_del + "</b></center> " + st.generate_html() + "</html>" : "GISTIC analysis data: move mouse over a colored region for details";
        } else {
            result = this.generate_tooltip(mp, label, array);
        }
        return result.length() > 0 ? result : null;
    }

    public void set_gistic_mode(boolean v) {
        this.gistic_mode = v;
        this.repaint();
    }

    public void mouseClicked(MouseEvent e) {
        if (!this.gistic_mode) {
            super.mouseClicked(e);
        }
    }

    private Color fade_color(Color c) {
        float fade_fraction = 0.5f;
        int[] rgb = new int[]{c.getRed(), c.getGreen(), c.getBlue()};
        int i = 0;
        while (i < 3) {
            int left = 255 - rgb[i];
            int amount = (int)((float)left * fade_fraction);
            int n = i++;
            rgb[n] = rgb[n] + amount;
        }
        Color result = new Color(rgb[0], rgb[1], rgb[2]);
        return result;
    }
}

