/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.Options;
import TCGA.Range;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackInfo {
    private static byte DEFAULT_VALUE = 1;
    public static final String TRACK_START_KEY = "track_name";
    private String track_name;
    private Color track_color = Options.DEFAULT_CUSTOM_TRACK_COLOR;
    HashSet<Integer> ranges = null;
    ArrayList<Range> ranges2 = new ArrayList();
    HashMap<Integer, Byte> range_values = null;
    private byte max_range_value = 0;
    private byte[] active = null;
    private int width;
    private byte default_value = DEFAULT_VALUE;

    public void add(String key, String value) {
        if (key.equals(TRACK_START_KEY)) {
            this.track_name = value;
        } else if (key.equals("track_bin")) {
            this.parse_ranges(value);
        } else if (key.equals("track_color")) {
            String[] c = value.split(",");
            if (c.length == 3) {
                this.track_color = new Color(Integer.parseInt(c[0]), Integer.parseInt(c[1]), Integer.parseInt(c[2]));
            } else {
                System.err.println("error in #track_color: must be R,G,B");
            }
        } else if (key.equals("track_constant")) {
            this.default_value = Byte.parseByte(value);
        }
    }

    public void set_width(int width) {
        this.width = width;
        this.active = new byte[width];
        for (int i = 0; i < width; ++i) {
            byte v = 0;
            if (this.ranges.contains(i + 1)) {
                v = this.range_values.containsKey(i + 1) ? this.range_values.get(new Integer(i + 1)) : this.default_value;
            }
            this.active[i] = v;
        }
    }

    private void parse_ranges(String value) {
        this.ranges = new HashSet();
        this.range_values = new HashMap();
        String[] things = value.split(",");
        this.max_range_value = 0;
        for (int i = 0; i < things.length; ++i) {
            int end;
            int start;
            String thing = things[i];
            Byte range_value = null;
            if (thing.indexOf(":") > -1) {
                String[] t2 = thing.split(":");
                thing = t2[0];
                range_value = new Byte(t2[1]);
                if (range_value > this.max_range_value) {
                    this.max_range_value = range_value;
                }
            }
            if (thing.indexOf("-") > -1) {
                String[] range = thing.split("-");
                start = Integer.parseInt(range[0]);
                end = Integer.parseInt(range[1]);
            } else {
                start = end = Integer.parseInt(thing);
            }
            this.ranges2.add(new Range(start, end));
            for (int j = start; j <= end; ++j) {
                Integer key = new Integer(j);
                this.ranges.add(key);
                if (range_value == null) continue;
                this.range_values.put(key, range_value);
            }
        }
    }

    public int get_width() {
        return this.width;
    }

    public String get_name() {
        return this.track_name;
    }

    public byte[] get_active() {
        return this.active;
    }

    public Color get_color() {
        return this.track_color;
    }

    public byte get_max_value() {
        return this.max_range_value > this.default_value ? this.max_range_value : this.default_value;
    }

    public Range get_range(int i) {
        ++i;
        Range result_r = null;
        for (Range r : this.ranges2) {
            if (i < r.start || i > r.end) continue;
            result_r = r;
            break;
        }
        return result_r;
    }

    public Rectangle get_range_selection(int i) {
        Rectangle result = null;
        Range result_r = this.get_range(i);
        if (result_r != null) {
            result = new Rectangle();
            result.x = result_r.start - 1;
            result.width = result_r.end - result_r.start + 1;
        }
        return result;
    }

    public void collapse_to(ArrayList<Integer> used_bins) {
        int new_index = 1;
        HashSet<Integer> new_ranges = new HashSet<Integer>();
        ArrayList<Range> new_ranges2 = new ArrayList<Range>();
        for (Integer wanted_bin : used_bins) {
            if (this.ranges.contains(wanted_bin + 1)) {
                new_ranges.add(new_index);
                new_ranges2.add(new Range(new_index, new_index));
            }
            ++new_index;
        }
        this.ranges = new_ranges;
        this.ranges2 = new_ranges2;
    }
}

