/*
 * Decompiled with CFR 0.152.
 */
package Trace;

import Funk.DelimitedFile;
import Trace.GenotypeData;
import Trace.GenotypeTrace;
import Trace.GenotypeViewer;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenotypeParser {
    private Hashtable<String, GenotypeData> snps;
    private Vector<String> sorted_snps;
    private HashSet<String> all_traces;
    private HashMap<String, String> t2o;
    private HashMap<String, GenotypeTrace> all_gt;
    private URL url;
    public static boolean OLD_MODE = false;

    public GenotypeParser(String filename) throws Exception {
        FileInputStream fis = new FileInputStream(filename);
        this.setup(fis);
    }

    public GenotypeParser(URL url) throws Exception {
        this.url = url;
        URLConnection uc = url.openConnection();
        this.setup(uc.getInputStream());
    }

    private void setup(InputStream is) throws Exception {
        if (OLD_MODE) {
            this.parse_old(is);
        } else {
            this.parse_input(is);
        }
    }

    public URL get_url() {
        return this.url;
    }

    private void parse_input(InputStream is) throws Exception {
        DelimitedFile df = new DelimitedFile();
        df.uppercase_labels(true);
        df.parse(is);
        Enumeration rows = df.get_rows_enumeration();
        this.snps = new Hashtable();
        this.all_traces = new HashSet();
        this.t2o = new HashMap();
        this.all_gt = new HashMap();
        while (rows.hasMoreElements()) {
            GenotypeData gd;
            Hashtable row = (Hashtable)rows.nextElement();
            String snp_name = (String)row.get("SNPNAME");
            if (this.snps.containsKey(snp_name)) {
                gd = this.snps.get(snp_name);
            } else {
                gd = new GenotypeData();
                gd.snp_name = snp_name;
                this.snps.put(snp_name, gd);
            }
            gd.sample_id = (String)row.get("SAMPLEID");
            gd.genotype_quality = this.hash_int(row, "SNPGENOTYPEQUALITY");
            GenotypeTrace gt = new GenotypeTrace();
            gt.allele_1 = (String)row.get("ALLELE1");
            gt.allele_2 = (String)row.get("ALLELE2");
            gt.trace_id = (String)row.get("TRACEID");
            gt.trace_label = (String)row.get("TRACELABEL");
            gt.trace_offset = this.hash_int(row, "TRACEOFFSET");
            gt.sequence_position = this.hash_int(row, "SNPPOS");
            gt.orientation = (String)row.get("ORIENTATION");
            gt.genotype_quality = this.hash_int(row, "TRACEGENOTYPEQUALITY");
            this.all_traces.add(gt.trace_id);
            this.all_gt.put(gt.trace_id, gt);
            if (this.t2o.containsKey(gt.trace_id)) {
                if (!this.t2o.get(gt.trace_id).equals(gt.orientation)) {
                    throw new Exception("trace orientation mismatch!");
                }
            } else {
                this.t2o.put(gt.trace_id, gt.orientation);
            }
            gd.add_trace(gt);
        }
        this.sorted_snps = new Vector<String>(this.snps.keySet());
        Collections.sort(this.sorted_snps);
    }

    private void parse_old(InputStream is) throws Exception {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        this.snps = new Hashtable();
        this.all_traces = new HashSet();
        this.all_gt = new HashMap();
        this.t2o = new HashMap();
        while ((line = br.readLine()) != null) {
            GenotypeData gd;
            StringTokenizer st = new StringTokenizer(line);
            String snp_name = st.nextToken();
            if (this.snps.containsKey(snp_name)) {
                gd = this.snps.get(snp_name);
            } else {
                gd = new GenotypeData();
                gd.snp_name = snp_name;
                this.snps.put(snp_name, gd);
            }
            gd.sample_id = st.nextToken();
            String allele_1 = st.nextToken();
            String allele_2 = st.nextToken();
            gd.genotype_quality = Integer.parseInt(st.nextToken());
            while (st.hasMoreTokens()) {
                GenotypeTrace gt = new GenotypeTrace();
                gt.allele_1 = allele_1;
                gt.allele_2 = allele_2;
                gt.trace_id = st.nextToken();
                gt.trace_offset = Integer.parseInt(st.nextToken());
                gt.sequence_position = Integer.parseInt(st.nextToken());
                gt.orientation = st.nextToken();
                gt.genotype_quality = Integer.parseInt(st.nextToken());
                this.all_traces.add(gt.trace_id);
                this.all_gt.put(gt.trace_id, gt);
                if (this.t2o.containsKey(gt.trace_id)) {
                    if (!this.t2o.get(gt.trace_id).equals(gt.orientation)) {
                        throw new Exception("trace orientation mismatch!");
                    }
                } else {
                    this.t2o.put(gt.trace_id, gt.orientation);
                }
                gd.add_trace(gt);
            }
        }
        this.sorted_snps = new Vector<String>(this.snps.keySet());
        Collections.sort(this.sorted_snps);
    }

    public static void main(String[] argv) {
        try {
            String filename = argv.length > 0 ? argv[0] : "genotype_doubleallele.dat";
            System.err.println("loading from local file " + filename);
            GenotypeParser gp = new GenotypeParser(filename);
            new GenotypeViewer(gp);
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            new Exception().printStackTrace();
        }
    }

    public Vector<String> get_snp_ids() {
        return this.sorted_snps;
    }

    public GenotypeData get_genotypes_for_snp(String snp_id) {
        return this.snps.get(snp_id);
    }

    public HashSet<String> get_unique_traces() {
        return this.all_traces;
    }

    public GenotypeTrace get_genotypetrace_for(String trace) {
        return this.all_gt.get(trace);
    }

    public String get_orientation_for(String trace) {
        return this.t2o.get(trace);
    }

    private void die() {
        this.die("dying");
    }

    private void die(String msg) {
        System.err.println(msg);
        System.exit(1);
    }

    private int hash_int(Hashtable ht, String key) {
        int result = 0;
        if (ht.containsKey(key)) {
            result = Integer.parseInt((String)ht.get(key));
        }
        return result;
    }
}

