/*
 * Decompiled with CFR 0.152.
 */
package Trace;

import Funk.CheckboxMenuGroup;
import Funk.CloseFrame;
import Funk.Counter;
import Funk.Message;
import Funk.MultiScrollPanel;
import Funk.Str;
import Trace.GenotypeData;
import Trace.GenotypeParser;
import Trace.GenotypeTrace;
import Trace.GenotypeViewerCredits;
import Trace.StreamDelegator;
import Trace.TraceCanvas;
import Trace.TraceDataView;
import Trace.TraceFile;
import Trace.TraceLoader;
import Trace.TracePanel;
import Trace.TraceServerClient;
import Trace.TraceZoomer;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JProgressBar;

public class GenotypeViewer
extends CloseFrame
implements ItemListener,
ActionListener,
MouseWheelListener,
AdjustmentListener,
Observer {
    private static boolean LOCAL_MODE = false;
    private static boolean SINGLE_LOAD = false;
    private static boolean DEFAULT_DYNAMIC_NORMALIZATION = true;
    private static boolean DEFAULT_LOCK_SCROLLING = true;
    private static int PREFERRED_WIDTH_PERCENT = 50;
    private HashMap<String, TracePanel> trace2panel;
    private GenotypeParser gp;
    private MultiScrollPanel msp;
    private Counter progress;
    private TraceZoomer tz = new TraceZoomer();
    private HashSet<String> unique_trace_list;
    private static final String GENOTYPE_ANY = "Any";
    private static final String GENOTYPE_HETEROZYGOUS = "Heterozygous";
    private Choice snp_chooser;
    private Choice genotype_chooser;
    private MenuItem mi_recenter;
    private MenuItem mi_quit;
    private MenuItem mi_about;
    private MenuItem mi_snap;
    private MenuItem mi_zoom_in;
    private MenuItem mi_zoom_out;
    private MenuItem mi_zoom_reset;
    private MenuItem mi_zoom_max;
    private MenuItem mi_zoom_min;
    private MenuItem mi_download;
    private CheckboxMenuItem cmi_aa;
    private CheckboxMenuItem cmi_ls;
    private CheckboxMenuItem cmi_dn_nolimit;
    private Panel controls;
    private Applet applet;
    private Label loading_message;
    private JProgressBar loading_progress;
    private CheckboxMenuGroup cmg_dn;

    public GenotypeViewer(GenotypeParser gp) throws IOException {
        this.gp = gp;
        this.setup();
    }

    public GenotypeViewer(GenotypeParser gp, Applet a) throws IOException {
        this.gp = gp;
        this.applet = a;
        this.setup();
    }

    public static void set_window_width_percent(int w) {
        PREFERRED_WIDTH_PERCENT = w;
    }

    public static void main(String[] argv) {
        StreamDelegator.guess_compression();
        StreamDelegator.set_local(true);
        String file = null;
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-local")) {
                System.err.println("enabling local mode");
                LOCAL_MODE = true;
                SINGLE_LOAD = true;
                TraceLoader.LOCAL_MODE = true;
                continue;
            }
            if (argv[i].equals("-old")) {
                System.err.println("enabling old genotype.dat format");
                GenotypeParser.OLD_MODE = true;
                continue;
            }
            if (!argv[i].equals("-file")) continue;
            file = argv[++i];
        }
        if (file == null) {
            file = LOCAL_MODE ? (GenotypeParser.OLD_MODE ? "genotype_fixed.dat" : "genotype_small_labeled.dat") : "crash.dat";
        }
        GenotypeParser gp = null;
        try {
            System.err.println("data file: " + file);
            gp = new GenotypeParser(file);
            new GenotypeViewer(gp);
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
        }
    }

    void setup() throws IOException {
        block7: {
            TraceCanvas.set_scroll_by_bases(true);
            TraceCanvas.set_fixed_bases_scroll(true);
            this.msp = new MultiScrollPanel();
            this.trace2panel = new HashMap();
            MenuBar mb = new MenuBar();
            this.setMenuBar(mb);
            Menu m = new Menu("File");
            this.mi_download = new MenuItem("Download traces");
            m.add(this.mi_download);
            this.mi_quit = new MenuItem("Exit");
            m.add(this.mi_quit);
            mb.add(m);
            m = new Menu("View");
            this.mi_recenter = new MenuItem("Recenter");
            m.add(this.mi_recenter);
            this.mi_snap = new MenuItem("Snap");
            m.add(this.mi_snap);
            m.add(new MenuItem("-"));
            Menu m2 = new Menu("Zoom");
            this.mi_zoom_in = new MenuItem("In");
            m2.add(this.mi_zoom_in);
            this.mi_zoom_out = new MenuItem("Out");
            m2.add(this.mi_zoom_out);
            m2.add(new MenuItem("-"));
            this.mi_zoom_max = new MenuItem("Max in");
            m2.add(this.mi_zoom_max);
            this.mi_zoom_min = new MenuItem("Max out");
            m2.add(this.mi_zoom_min);
            m2.add(new MenuItem("-"));
            this.mi_zoom_reset = new MenuItem("Reset");
            m2.add(this.mi_zoom_reset);
            m.add(m2);
            mb.add(m);
            m = new Menu("Options");
            Menu m3 = new Menu("Dynamic normalization");
            m3.add(new MenuItem("Maximum zoom:"));
            this.cmg_dn = new CheckboxMenuGroup();
            for (int i = 1; i <= 10; ++i) {
                String label = "  " + i + "x";
                if (i == 1) {
                    label = label.concat("  (disable)");
                }
                CheckboxMenuItem cmi = new CheckboxMenuItem(label, i == 5);
                this.cmg_dn.add(cmi);
                m3.add(cmi);
                cmi.addItemListener(this);
            }
            this.cmi_dn_nolimit = new CheckboxMenuItem("  unlimited", false);
            m3.add(this.cmi_dn_nolimit);
            this.cmg_dn.add(this.cmi_dn_nolimit);
            this.cmi_dn_nolimit.addItemListener(this);
            m.add(m3);
            this.cmi_ls = new CheckboxMenuItem("Synchronize trace scrolling", DEFAULT_LOCK_SCROLLING);
            m.add(this.cmi_ls);
            this.cmi_aa = new CheckboxMenuItem("Antialiasing", true);
            m.add(this.cmi_aa);
            TraceDataView.set_static_auto_normalization(DEFAULT_DYNAMIC_NORMALIZATION);
            mb.add(m);
            m = new Menu("Help");
            this.mi_about = new MenuItem("About");
            m.add(this.mi_about);
            mb.add(m);
            this.mi_recenter.addActionListener(this);
            this.mi_quit.addActionListener(this);
            this.mi_about.addActionListener(this);
            this.mi_snap.addActionListener(this);
            this.mi_zoom_in.addActionListener(this);
            this.mi_zoom_out.addActionListener(this);
            this.mi_zoom_reset.addActionListener(this);
            this.mi_zoom_max.addActionListener(this);
            this.mi_zoom_min.addActionListener(this);
            this.mi_download.addActionListener(this);
            this.cmi_aa.addItemListener(this);
            this.setLayout(new BorderLayout());
            this.add("Center", this.msp);
            this.controls = new Panel();
            this.controls.addMouseWheelListener(this);
            FlowLayout cpl = new FlowLayout();
            Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
            int set_width = ss.width * PREFERRED_WIDTH_PERCENT / 100;
            this.loading_progress = new JProgressBar();
            this.loading_progress.setString("Loading...");
            this.loading_progress.setStringPainted(true);
            this.loading_progress.setMinimum(0);
            this.loading_progress.setMaximum(100);
            Dimension pref = this.loading_progress.getPreferredSize();
            pref.width = (int)((double)set_width * 0.9);
            this.loading_progress.setPreferredSize(pref);
            this.controls.add(this.loading_progress);
            this.controls.setLayout(cpl);
            this.snp_chooser = new Choice();
            this.snp_chooser.addItemListener(this);
            Vector<String> snps = this.gp.get_snp_ids();
            for (String s : snps) {
                this.snp_chooser.add(s);
            }
            this.genotype_chooser = new Choice();
            this.genotype_chooser.addItemListener(this);
            this.add("North", this.controls);
            this.change_snp_view();
            this.pack();
            this.setSize(set_width, this.getSize().height);
            this.setVisible(true);
            this.toFront();
            this.unique_trace_list = this.gp.get_unique_traces();
            this.progress = new Counter(this.unique_trace_list);
            if (SINGLE_LOAD) {
                TraceLoader tl = new TraceLoader(this.unique_trace_list, this);
            } else {
                TraceServerClient tsc = new TraceServerClient();
                try {
                    tsc.get_traces(this.unique_trace_list, this);
                }
                catch (FileNotFoundException fnf) {
                    String error_message = "Error: " + fnf.getMessage();
                    new Message(error_message);
                    if (this.loading_progress == null) break block7;
                    this.loading_progress.setString(error_message);
                }
            }
        }
    }

    public void change_snp_view() {
        String snp_id = this.snp_chooser.getSelectedItem();
        GenotypeData gd = this.gp.get_genotypes_for_snp(snp_id);
        this.genotype_chooser.removeAll();
        this.genotype_chooser.add(GENOTYPE_ANY);
        HashSet alleles = gd.get_alleles();
        for (String allele : alleles) {
            this.genotype_chooser.add(allele);
        }
        this.genotype_chooser.add(GENOTYPE_HETEROZYGOUS);
        this.set_view();
    }

    public void set_view() {
        String snp_id = this.snp_chooser.getSelectedItem();
        GenotypeData gd = this.gp.get_genotypes_for_snp(snp_id);
        this.recenter_all();
        this.msp.removeAll();
        String current_genotype = this.genotype_chooser.getSelectedItem();
        for (GenotypeTrace gt : gd.traces) {
            TracePanel tp = this.trace2panel.get(gt.trace_id);
            if (tp == null || !(current_genotype.equals(GENOTYPE_HETEROZYGOUS) ? gt.is_heterozygous() : current_genotype.equals(GENOTYPE_ANY) || gt.contains_allele(current_genotype))) continue;
            this.msp.add(tp);
        }
        this.msp.validate();
    }

    public void recenter_all() {
        String snp_id = this.snp_chooser.getSelectedItem();
        GenotypeData gd = this.gp.get_genotypes_for_snp(snp_id);
        for (GenotypeTrace gt : gd.traces) {
            TracePanel tp = this.trace2panel.get(gt.trace_id);
            if (tp == null) continue;
            tp.center_on(gt.trace_offset, true);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source.equals(this.snp_chooser)) {
            this.change_snp_view();
        } else if (source.equals(this.genotype_chooser)) {
            this.set_view();
        } else if (source.equals(this.cmi_aa)) {
            TraceCanvas.set_antialiasing(this.cmi_aa.getState());
            this.msp.validate();
        } else if (source.equals(this.cmi_dn_nolimit)) {
            TraceDataView.set_static_auto_normalization(true);
            TraceDataView.set_static_auto_normalization_limit(0.0);
            this.msp.validate();
        } else if (source instanceof CheckboxMenuItem && this.cmg_dn.contains((CheckboxMenuItem)source)) {
            CheckboxMenuItem selected = (CheckboxMenuItem)source;
            String label = selected.getLabel();
            String amt = Str.trim_whitespace(label.substring(0, label.indexOf("x")));
            Double factor = Double.parseDouble(amt);
            if (factor == 1.0) {
                TraceDataView.set_static_auto_normalization(false);
            } else {
                TraceDataView.set_static_auto_normalization(true);
                TraceDataView.set_static_auto_normalization_limit(factor);
            }
            this.msp.validate();
        } else {
            System.err.println("unhandled: " + e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.mi_recenter)) {
            this.recenter_all();
        } else if (source.equals(this.mi_quit)) {
            this.setVisible(false);
            this.dispose();
        } else if (source.equals(this.mi_about)) {
            new GenotypeViewerCredits();
        } else if (source.equals(this.mi_snap)) {
            this.msp.snap(false);
        } else if (source.equals(this.mi_zoom_in)) {
            this.tz.zoom(-2);
            this.msp.validate();
        } else if (source.equals(this.mi_zoom_out)) {
            this.tz.zoom(2);
            this.msp.validate();
        } else if (source.equals(this.mi_zoom_max)) {
            this.tz.zoom_to_maximum();
            this.msp.validate();
        } else if (source.equals(this.mi_zoom_min)) {
            this.tz.zoom_to_minimum();
            this.msp.validate();
        } else if (source.equals(this.mi_zoom_reset)) {
            this.tz.reset();
            this.msp.validate();
        } else if (source.equals(this.mi_download)) {
            this.download_traces();
        } else {
            System.err.println("unhandled: " + e);
        }
    }

    public void update(Observable o, Object arg) {
        TraceFile t = null;
        if (o instanceof TraceLoader) {
            TraceLoader tl = (TraceLoader)o;
            t = (TraceFile)arg;
        } else if (o instanceof TraceServerClient) {
            t = (TraceFile)arg;
        } else {
            System.err.println("unhandled update!");
        }
        if (t != null) {
            this.progress.next();
            this.stash_panel(t);
            int complete = this.progress.get_percent_complete();
            String msg = "Loading (" + complete + "%)...";
            if (this.progress.complete()) {
                this.controls.removeAll();
                this.controls.add(new Label("SNP:"));
                this.controls.add(this.snp_chooser);
                this.controls.add(new Label("allele:"));
                this.controls.add(this.genotype_chooser);
                this.controls.validate();
                this.set_view();
                this.msp.snap(true);
                this.toFront();
            } else if (this.loading_message != null) {
                System.err.println(msg);
                this.loading_message.setText(msg);
                this.controls.validate();
            } else if (this.loading_progress != null) {
                this.loading_progress.setValue(complete);
                this.loading_progress.setString(msg);
                this.controls.validate();
            }
        }
    }

    private void stash_panel(TraceFile t) {
        String orientation = this.gp.get_orientation_for(t.name);
        Panel info = new Panel();
        FlowLayout bl = new FlowLayout();
        bl.setAlignment(0);
        info.setLayout(bl);
        GenotypeTrace gt = this.gp.get_genotypetrace_for(t.name);
        String label = gt.trace_label;
        if (label == null) {
            label = gt.trace_id + " (" + gt.orientation + ")";
        }
        info.add(new Label(label));
        if (orientation.equals("-")) {
            t.reverse_complement();
        }
        TracePanel tp = new TracePanel(t, label);
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        int preferred_width = ss.width;
        int preferred_panel_height = (int)((double)ss.height * 0.22);
        tp.setPreferredSize(new Dimension(preferred_width, preferred_panel_height));
        tp.setMinimumSize(new Dimension(preferred_width, preferred_panel_height));
        tp.setMaximumSize(new Dimension(ss.width, preferred_panel_height));
        Scrollbar sb = tp.get_scrollbar();
        sb.addAdjustmentListener(this);
        this.trace2panel.put(t.name, tp);
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        int rotation = e.getWheelRotation();
        this.tz.zoom(rotation);
        this.repaint_all();
    }

    private void repaint_all() {
        for (TracePanel tp : this.trace2panel.values()) {
            tp.repaint();
        }
        this.msp.validate();
    }

    private void download_traces() {
        TraceServerClient tsc = new TraceServerClient();
        URL url = this.gp.get_url();
        URL dl = tsc.get_download_url(this.unique_trace_list, url == null ? "" : url.toString());
        System.err.println(dl.toString());
        if (this.applet == null) {
            new Message("can't launch download URL: no applet", "OK");
        } else {
            this.applet.getAppletContext().showDocument(dl, "Download");
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (this.cmi_ls.getState()) {
            Scrollbar sb;
            Scrollbar source_sb = (Scrollbar)e.getSource();
            int abs_delta = 0;
            for (TracePanel tp : this.trace2panel.values()) {
                sb = tp.get_scrollbar();
                if (!sb.equals(source_sb)) continue;
                abs_delta = tp.get_bases_delta_since_start();
                break;
            }
            for (TracePanel tp : this.trace2panel.values()) {
                sb = tp.get_scrollbar();
                if (sb.equals(source_sb)) continue;
                tp.apply_absolute_delta(abs_delta);
            }
        }
    }
}

