/*
 * Decompiled with CFR 0.152.
 */
package Trace;

import Funk.JCloseButton;
import Trace.JTraceCanvas;
import Trace.PhdFile;
import Trace.TraceFile;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class JTracePanel
extends JPanel
implements ActionListener,
AdjustmentListener {
    String filename;
    private JTraceCanvas canvas;
    private boolean start_rc = false;
    private int start_position = 0;
    private TraceFile trace = null;
    private JButton center_button = null;
    private JPanel manual_panel = null;
    private String trace_label = null;
    private JScrollBar hs;
    private int last_value = 0;
    private boolean have_last_value = false;
    private static boolean is_applet = false;

    public JTracePanel(String filename) {
        this.filename = filename;
        this.setup();
    }

    public JTracePanel(TraceFile t) {
        this.filename = t.name;
        this.trace = t;
        this.setup();
    }

    public JTracePanel(String filename, int position) {
        this.filename = filename;
        this.start_position = position;
        this.setup();
    }

    public JTracePanel(String filename, boolean reverse_complemented) {
        this.filename = filename;
        this.start_rc = reverse_complemented;
        this.setup();
    }

    public JTracePanel(TraceFile t, JPanel manual_panel) {
        this.filename = t.name;
        this.trace = t;
        this.manual_panel = manual_panel;
        this.setup();
    }

    public JTracePanel(TraceFile t, String trace_label) {
        this.trace = t;
        this.filename = t.name;
        this.trace_label = trace_label;
        this.setup();
    }

    public JTracePanel(String filename, int position, boolean reverse_complemented) {
        this.filename = filename;
        this.start_rc = reverse_complemented;
        this.start_position = position;
        this.setup();
    }

    void setup() {
        this.setLayout(new BorderLayout());
        JPanel cp = null;
        if (this.manual_panel != null) {
            cp = this.manual_panel;
        } else if (!(this.trace_label != null || this.start_position <= 0 && is_applet)) {
            cp = new JPanel();
            cp.setLayout(new BorderLayout());
            if (!is_applet) {
                cp.add("East", new JCloseButton());
            }
            if (this.start_position > 0) {
                this.center_button = new JButton("Center");
                this.center_button.addActionListener(this);
                cp.add("West", this.center_button);
            }
        }
        if (cp != null) {
            this.add("North", cp);
        }
        this.hs = new JScrollBar(0, 0, 0, 0, 0);
        this.hs.addAdjustmentListener(this);
        this.canvas = this.trace == null ? new JTraceCanvas(this.filename, this.start_position, this.start_rc, this.hs) : new JTraceCanvas(this.trace, this.start_position, this.hs, this.trace_label);
        this.add("Center", this.canvas);
        this.add("South", this.hs);
    }

    public void center_on(int i) {
        if (this.canvas != null) {
            this.canvas.center_on(i);
        }
    }

    public void center_on(int i, boolean auto_rc) {
        if (this.canvas != null) {
            this.canvas.center_on(i, auto_rc);
        }
    }

    public void go_to(TraceFile tf, int offset) {
        this.canvas.go_to(tf, offset);
    }

    public void setPhd(PhdFile p) {
        this.canvas.setPhd(p);
    }

    public boolean loaded() {
        return this.canvas.loaded();
    }

    public boolean error() {
        return this.canvas.error();
    }

    public TraceFile get_trace() {
        return this.canvas.get_trace();
    }

    public void actionPerformed(ActionEvent e) {
        this.center_on(this.start_position);
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.canvas.repaint();
    }

    public JScrollBar get_scrollbar() {
        return this.hs;
    }

    public synchronized void mimic_AdjustmentEvent(AdjustmentEvent e, int delta) {
        int type = e.getAdjustmentType();
        int direction = 1;
        int amount = 0;
        if (type == 1) {
            direction = 1;
            amount = this.hs.getUnitIncrement();
        } else if (type == 2) {
            direction = -1;
            amount = this.hs.getUnitIncrement();
        } else if (type == 4) {
            direction = 1;
            amount = this.hs.getBlockIncrement();
        } else if (type == 3) {
            direction = -1;
            amount = this.hs.getBlockIncrement();
        } else if (type == 5) {
            System.err.println("using delta: " + delta);
            direction = delta >= 0 ? 1 : -1;
            amount = Math.abs(delta);
        } else {
            System.err.println("WARNING: unhandled AdjustmentEvent type: " + e);
        }
        if (amount > 0) {
            this.hs.setValue(this.hs.getValue() + amount * direction);
            this.canvas.repaint();
        }
    }

    public int get_bases_delta_since_start() {
        return this.canvas.get_bases_delta_since_start();
    }

    public void apply_absolute_delta(int d) {
        this.canvas.apply_absolute_delta(d);
    }
}

